#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management.base import BaseCommand, CommandError
import traceback
import logging
from libs.es import ESPerform
from django.db import models
import datetime


class TopicTag(models.Model):
    class Meta:
        verbose_name=u"帖子标签"
        db_table="community_topictag"

    id = models.IntegerField(primary_key=True,verbose_name=u"主键ID")
    tag_id = models.IntegerField(verbose_name=u"标签ID")
    topic_id = models.IntegerField(verbose_name=u"帖子ID")
    is_online = models.BooleanField(verbose_name=u"是否在线")



class AccountUserTag(models.Model):
    class Meta:
        verbose_name=u"用户标签"
        db_table="account_user_tag"

    id = models.IntegerField(primary_key=True,verbose_name=u"主键ID")
    tag_id = models.IntegerField(verbose_name=u"标签ID")
    user = models.IntegerField(verbose_name=u"用户ID")
    is_deleted = models.BooleanField(verbose_name=u"是否删除")
    create_time = models.DateTimeField(verbose_name=u'创建时间',default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=datetime.datetime.fromtimestamp(0))


class Tag(models.Model):
    class Meta:
        verbose_name=u"标签"
        db_table="community_tag"

    id = models.IntegerField(primary_key=True,verbose_name=u"主键ID")
    is_deleted = models.BooleanField(verbose_name=u"是否删除")
    is_online = models.BooleanField(verbose_name=u"是否上线")
    name = models.CharField(verbose_name=u"标签名称",max_length=128)
    description = models.TextField(verbose_name=u"标签描述")
    icon_url=models.CharField(verbose_name=u"icon_url",max_length=120)
    create_time = models.DateTimeField(verbose_name=u'创建时间',default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=datetime.datetime.fromtimestamp(0))
