#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import sys
import logging
import traceback
from libs.tools import tzlc
import time
import re
import datetime


class TopicTransfer(object):

    @classmethod
    def get_topic_data(cls,instance):
        try:
            res = dict()

            res["id"] = instance.id
            res["is_online"] = instance.is_online
            res["is_deleted"] = instance.is_deleted
            res["vote_num"] = instance.vote_num
            res["reply_num"] = instance.reply_num
            res["name"] = instance.name
            res["description"] = instance.description
            res["content"] = instance.content
            res["content_level"] = instance.content_level
            res["user_id"] = instance.user_id

            if instance.group:
                res["group_id"] = instance.group.id
            else:
                res["group_id"] = -1
            res["share_num"] = instance.share_num

            res["pick_id_list"] = instance.get_pick_id_info()

            begin = datetime.datetime.now()
            (topic_tag_id_list, edit_tag_id_list) = instance.get_topic_tag_id_list()
            res["tag_list"] = topic_tag_id_list
            res["edit_tag_list"] = edit_tag_id_list
            end = datetime.datetime.now()
            time1 = (end-begin).seconds

            begin = datetime.datetime.now()
            res["tag_name_list"] = instance.get_tag_name_list(res["tag_list"])
            end = datetime.datetime.now()
            time2 = (end-begin).seconds


            begin = datetime.datetime.now()
            res["offline_score"] = instance.get_topic_offline_score()
            end = datetime.datetime.now()
            time3 = (end-begin).seconds


            res["manual_score"] = instance.drop_score
            res["has_image"] = instance.topic_has_image()
            res["language_type"] = instance.language_type

            # # 片假名
            # re_jp_pian_words = re.compile(u"[\u30a0-\u30ff]+")
            # m_pian = re_jp_pian_words.search(instance.content, 0)
            #
            # # 平假名
            # re_jp_ping_words = re.compile(u"[\u3040-\u309f]+")
            # m_ping = re_jp_ping_words.search(instance.content, 0)

            # if m_pian or m_ping:
            #     res["language_type"] = 10
            # else:
            #     res["language_type"] = instance.language_type


            create_time = instance.create_time
            tzlc_create_time = tzlc(create_time)
            res["create_time"] = tzlc_create_time
            res["create_time_val"] = int(time.mktime(tzlc_create_time.timetuple()))


            update_time = instance.update_time
            tzlc_update_time = tzlc(update_time)
            res["update_time"] = tzlc_update_time
            res["update_time_val"] = int(time.mktime(tzlc_update_time.timetuple()))

            logging.info("test topic transfer time cost,time1:%d,time2:%d,time3:%d" % (time1,time2,time3))
            return res
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return None