strategy part like es perform
容器运行命令
docker run -it -p 9999:9999 -d \
--volume=/etc/gm-config:/etc/gm-config \
--volume=/etc/resolv.conf:/etc/resolv.conf  \
--volume=/srv/apps/physical/physical/settings_local.py:/srv/apps/physical/physical/settings_local.py \
--entrypoint="/bin/bash" physical-test:1.0 "-c" "source ~/.bashrc && celery -A physical worker -Q tapir-alpha --loglevel=DEBUG  --maxtasksperchild 500 -c 62"


## 启动方式

### 方式1：[program:physical-linucb] 消费kafka数据 
一个while True服务，去消费kafka数据，维护redis中device的tag_map
```python
source /srv/envs/physical/bin/activate && python manage.py trans2es_data2es_parallel -S linucb
```

### 方式2：[program:physical] rpc服务
启动rpc服务供后端调用, 接口都在search文件夹下的bind函数定义
```python
gunicorn gm_rpcd.wsgi:application --workers=1 --worker-class=gevent 
--worker-connections=1024 
--bind=0.0.0.0:9999 
--user=gmuser 
--chdir /srv/apps/physical/ 
--timeout 600 
--log-level=debug  
--error-logfile=/data/log/physical/app/gunicorn_error.log 
--access-logfile=/data/log/physical/app/gunicorn_access.log
```

### 方式3 [program:physical-celery] celery 消息队列服务
mysql数据同步到es，入口文件：injection.data_sync.tasks.write_to_es
数据同步工作大部分在数据管道，只有小部分在这，暂时先不用管这个服务，需求用不到
```python
celery -A physical worker -Q tapir-alpha --loglevel=DEBUG  --maxtasksperchild 500 -c 62
```

### 方式4 [program:physical-beat-celery] celery 消息队列定时（作用未知）
```python
celery -A physical beat
```

# 自动运行脚本
### venus服务端脚本
通过celery beat 运行
配置说明文件：venus/setting/base.py
具体脚本：venus/communityity/task/xxx.py
目前共5个脚本
1：每天保存用户扫脸图片：community.tasks.save_image_task.save_user_face_image
2：每天3点0分评论自动点赞：community.tasks.crontab_reply_vote_task.crontab_reply_vote
3：向用户推送兴趣标签：community.tasks.push_task.push_interest_tag_pictorial_to_user
4：向用户推送经验标签：community.tasks.push_task.push_topic_draft_task
5：推送主题草稿任务：community.tasks.push_task.push_topic_draft_task

### physical策略端脚本
在Alp-Test-Cos-test001服务器上，通过crontab -l查看


### es常用命令
```bash
#修改别名：
curl -X POST -H "Content-Type: application/json" "http://172.17.32.22:9200/_aliases" -d '{"actions":[{"remove":{"index":"mv-alpha-product-prod-190904001","alias":"gm-dbmw-product-read"}},{"add":{"index":"mv-alpha-product-prod-191018401","alias":"gm-dbmw-product-read"}}]}'

#查看别名
curl -H "Content-Type: application/json" "http://172.17.32.22:9200/_aliases?pretty"

#查看所有索引
curl -H "Content-Type: application/json" "http://172.17.32.22:9200/_cat/indices?v"

#简单查询
curl -H "Content-Type: application/json" "http://172.17.32.22:9200/gm-dbmw-topic-high-star-read/_search?pretty" -d '{"query":{"term":{"id":"46710078"}}}'
```

### es同步确认脚本
cd /data/log/physical/app/index_contrast/
