#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, absolute_import, print_function
import os
import sys
import logging
import traceback
from libs.tools import tzlc
from trans2es.models.topic import Topic
from trans2es.models.tag import TopicTag, CommunityTagType, CommunityTagTypeRelation
import datetime
from django.conf import settings
import copy

class TagTransfer(object):

    @classmethod
    def get_tag_name_data(cls, instance):
        try:
            res = dict()
            res["name"] = instance.name

            return res
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return dict()

    @classmethod
    def get_tag_data(cls, instance):
        try:
            res = dict()

            res["id"] = instance.id

            begin_tag_name_terms_list = list()
            tag_name_terms_list = list()
            for i in range(len(instance.name)):
                for j in range(i, len(instance.name) + 1):
                    name_term = instance.name[i:j].strip()
                    if name_term:
                        if i == 0:
                            begin_tag_name_terms_list.append(name_term.lower())
                        else:
                            tag_name_terms_list.append(name_term.lower())

            res["suggest"] = {
                "input":tag_name_terms_list,
                "weight": 1,
                "contexts":{
                    "is_online": [instance.is_online],
                    "is_deleted": [instance.is_deleted]
                }
            }
            res["name"] = instance.name
            res["name_pre"] = instance.name
            res["is_online"] = instance.is_online
            res["is_deleted"] = instance.is_deleted

            topic_num = 0
            res["near_new_topic_num"] = topic_num
            if instance.is_online == True and instance.is_deleted == False:
                topic_id_list = list()

                sql_result_results = list(TopicTag.objects.using(settings.SLAVE_DB_NAME).filter(
                    tag_id=instance.id).values_list("topic_id", "is_online"))
                for topic_id, is_online in sql_result_results:
                    if is_online:
                        topic_id_list.append(topic_id)

                time_base_val = datetime.datetime.strftime(datetime.datetime.now() + datetime.timedelta(-7), "%Y-%m-%d")

                for topic_begin_index in range(0, len(topic_id_list), 100):
                    cur_topic_num = Topic.objects.using(settings.SLAVE_DB_NAME).filter(
                        id__in=topic_id_list[topic_begin_index:topic_begin_index + 100],
                        create_time__gte=time_base_val).count()
                    topic_num += cur_topic_num

                res["near_new_topic_num"] = topic_num

            tag_type_sql_list = CommunityTagTypeRelation.objects.using(settings.SLAVE_DB_NAME).filter(
                tag_id=instance.id).values_list("tag_type_id", flat=True)
            tag_type_list = list()
            for tag_type_id in tag_type_sql_list:
                tag_type_list.append(tag_type_id)

            res["tag_type"] = tag_type_list
            res["collection"] = instance.collection
            res["is_ai"] = instance.is_ai
            res["is_own"] = instance.is_own

            begin_res = copy.deepcopy(res)
            begin_res["id"] = begin_res["id"] + 600000000
            begin_res["suggest"]["input"] = begin_tag_name_terms_list
            begin_res["suggest"]["weight"] = 10

            return (res, begin_res)
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return (dict(), dict())
