#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import sys
import logging
import traceback
from libs.tools import tzlc
import time


class TopicTransfer(object):

    @classmethod
    def get_topic_data(cls,instance):
        try:
            res = dict()

            res["id"] = instance.id
            res["is_online"] = instance.is_online
            res["vote_num"] = instance.vote_num
            res["reply_num"] = instance.reply_num
            res["name"] = instance.name
            res["description"] = instance.description
            res["content"] = instance.content
            res["content_level"] = instance.content_level
            res["user_id"] = instance.user_id
            res["group_id"] = instance.group_id
            res["share_num"] = instance.share_num

            res["pick_id_list"] = instance.get_pick_id_info()
            res["tag_list"] = instance.get_topic_tag_id_list()
            res["offline_score"] = instance.get_topic_offline_score()

            create_time = instance.create_time
            tzlc_create_time = tzlc(create_time)
            res["create_time"] = tzlc_create_time
            res["create_time_val"] = time.mktime(tzlc_create_time.timetuple())


            update_time = instance.update_time
            tzlc_update_time = tzlc(update_time)
            res["update_time"] = tzlc_update_time
            res["update_time_val"] = time.mktime(tzlc_update_time.timetuple())

            return res
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return None