import pymysql
import random
import traceback
import logging
from vest.request.auto_request import logins, pictorial_reply, get_majia, get_pictorial_comment, time_conv_minute, \
    judge_pictorial_info_get_comment

from vest.request.auto_request import host, user, db, passwd
from vest.data.topic_models import get_pictorial_tag_by_id

"""
榜单新增内容(仅限在线的）
每半小时一次

过去半小时之内，if

新增在线帖子（既包含马甲用户、又包含普通用户）达到1个时，插入{1,2}条评论

新增在线帖子（既包含马甲用户、又包含普通用户）达到2-5个时，插入{2,3}条评论

新增在线帖子（既包含马甲用户、又包含普通用户）达到>5张时，插入{3,5}条评论

（注意评论作者需要是马甲用户）

过去半小时之内，if

本榜单有新增投票（既包含马甲用户、又包含普通用户），插入{1,2}条评论

评论取自单独的榜单评论列表，并自动随机关联马甲

注意需要禁止本帖作者评论
"""


def get_data(numtime1, numtime2):
    try:
        print("....")
        pc = pymysql.connect(host=host, user=user, passwd=passwd, db=db, port=3306)
        cursor = pc.cursor()
        cursor.execute(
            "SELECT  pictorial_id ,count(*) as count FROM community_pictorial_topic WHERE is_online=1 and (create_time >= '%s' and create_time < '%s') group by pictorial_id " % (
                numtime1, numtime2))
        data = cursor.fetchall()
        cursor.execute(
            "SELECT  pictorial_id  FROM topic_vote_cnt WHERE is_deleted = 0  and  (update_time >= '%s' and update_time < '%s') group by pictorial_id" % (
                numtime1, numtime2))
        data_vote = cursor.fetchall()

        pictorial_data = list(data)
        pictorial_vote = list(data_vote)
        logging.info("Database version : %s " % pictorial_data)
        logging.info("Database version : %s " % pictorial_vote)

        return pictorial_data, pictorial_vote

    except:
        logging.error("catch exception,get_data:%s" % traceback.format_exc())
        return []


def principal_online_comment1():
    # 根据问题内容，以及问题的评论条数据，给问题自动加评论，到这个表中取数据community_pictorial_topic
    try:
        logging.info("comment offline  pictorial")
        numtime1, numtime2, minute = time_conv_minute(240, 0)
        user_id, data_vote = get_data(numtime1, numtime2)

        random_num = 0
        if user_id:
            for i in user_id:
                if i[1] == 1:
                    random_num = random.randint(1, 2)
                if i[1] >= 2 and i[1] <= 5:
                    random_num = random.randint(2, 3)
                if i[1] > 5:
                    random_num = random.randint(3, 5)
                for num in range(random_num):
                    majia_user_id = get_majia()
                    cook = logins(majia_user_id)
                    comment = judge_pictorial_info_get_comment(i[0])
                    if cook is not None:
                        pictorial_reply(cook, i[0], comment)
            if data_vote:
                for i in data_vote:
                    random_num = random.randint(1, 2)
                    for num in range(random_num):
                        majia_user_id = get_majia()
                        cook = logins(majia_user_id)
                        comment = judge_pictorial_info_get_comment(i[0])
                        if cook is not None:
                            pictorial_reply(cook, i[0], comment)

            else:
                logging.error("catch exception,main:%s" % traceback.format_exc())
    except:
        logging.error("catch exception,main:%s" % traceback.format_exc())
