#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management.base import BaseCommand, CommandError
import traceback
import logging
from libs.es import ESPerform
from django.db import models
import datetime
from .group_user_role import GroupUserRole


class User(models.Model):
    class Meta:
        verbose_name = u'用户'
        verbose_name_plural = u'用户'
        db_table = 'account_user'
        app_label = 'api'

    id = models.IntegerField(verbose_name="主键ID",primary_key=True)
    user_id = models.BigIntegerField(verbose_name=u'用户id', unique=True)
    nick_name = models.CharField(verbose_name=u'昵称', max_length=255, default='')
    profile_pic = models.CharField(verbose_name=u'头像', max_length=300)
    gender = models.SmallIntegerField(verbose_name=u'性别')
    city_id = models.IntegerField(verbose_name=u'城市id')
    country_id = models.IntegerField(verbose_name='国家id')
    is_online = models.BooleanField(verbose_name="是否上线")
    create_time = models.DateTimeField(verbose_name=u'创建时间',default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=datetime.datetime.fromtimestamp(0))


    def get_follow_user_id_list(self):
        follow_user_id_list = list()
        user_follows = self.userfollow.filter(is_online=True)
        for user_follow in user_follows:
            follow_user_id_list.append(user_follow.follow_id)

        follow_user_detail_list = list()
        sql_data_list = User.objects.filter(user_id__in=follow_user_id_list)
        for detail_data in sql_data_list:
            item = {
                "user_id":detail_data.user_id,
                "country_id":detail_data.country_id
            }
            follow_user_detail_list.append(item)

        return follow_user_detail_list

    def get_pick_user_id_list(self):
        pick_user_id_list = list()
        user_picks = self.user_pick.filter(is_deleted=False)
        for user_pick in user_picks:
            pick_user_id_list.append(user_pick.pickuser_id)

        pick_user_detail_list = list()
        sql_data_list = User.objects.filter(user_id__in=pick_user_id_list)
        for detail_data in sql_data_list:
            item = {
                "user_id":detail_data.user_id,
                "country_id":detail_data.country_id
            }
            pick_user_detail_list.append(item)

        return pick_user_detail_list

    def get_same_group_user_id_list(self):
        same_group_user_id_list = list()
        group_items_list = GroupUserRole.objects.filter(user_id=self.user_id)
        for group_item in group_items_list:
            group_id = group_item.group_id
            user_items_list = GroupUserRole.objects.filter(group_id=group_id)
            for user_items_list in user_items_list:
                same_group_user_id_list.append(user_items_list.user_id)

        same_group_detail_list = list()
        sql_data_list = User.objects.filter(user_id__in=same_group_user_id_list)
        for detail_data in sql_data_list:
            item = {
                "user_id":detail_data.user_id,
                "country_id":detail_data.country_id
            }
            same_group_detail_list.append(item)

        return same_group_detail_list


