#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import sys
import logging
import traceback
from libs.tools import tzlc

class TopicTransfer(object):

    @classmethod
    def get_topic_data(cls,instance):
        try:
            res = dict()

            res["id"] = instance.id
            res["is_online"] = instance.is_online
            res["vote_num"] = instance.vote_num
            res["reply_num"] = instance.reply_num
            res["name"] = instance.name
            res["description"] = instance.description
            res["content"] = instance.content
            res["content_level"] = instance.content_level
            res["user_id"] = instance.user_id
            res["share_num"] = instance.share_num


            create_time = instance.create_time
            print("id is:%d,create_time is:%sm,tzinfo:%s" % (res["id"],str(create_time),str(create_time.tzinfo)))
            res["create_time"] = tzlc(create_time)

            """
            if create_time.tzinfo is None:
                res["create_time"] = tzlc(create_time)
            else:
                res["create_time"] = create_time.replace(microsecond=0)            
            """

            update_time = instance.update_time
            res["update_time"] = tzlc(update_time)

            """
            if update_time.tzinfo is None:
                res["update_time"] = tzlc(update_time)
            else:
                res["update_time"] = update_time.replace(microsecond=0)            
            """

            return res
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return None