import pymysql
import random
import traceback
import logging
from threading import Thread
from vest.request.auto_request import login, time_convs, follow
from vest.request.auto_request import host, user, db, passwd
from libs.error import logging_exception
from libs.timelib import get_rand_time


def get_commnet_id(numtime, numtime2, content_level_low=0, content_level_top=3):
    pc = pymysql.connect(host=host, user=user, passwd=passwd, db=db, port=3306)
    cursor = pc.cursor()

    # 发贴后
    cursor.execute(

        "select user_id from topic where is_shadow!= 1 and create_time > '%s' and create_time < '%s' "
        "and content_level >= %s and content_level <=  %s " % (numtime, numtime2, str(content_level_low), str(content_level_top)))

    res = cursor.fetchall()
    return res and [i for i, in res] or []


def batch_handle(auto_follow_list):
    for user_id in auto_follow_list:
        try:
            cookies = login()
            if cookies is not None:
                # follow(cookies, user_id)
                time = get_rand_time()
                follow.apply_async(args=(cookies, user_id), eta=time)

        except:
            pass


def auto_follow_per_1d_by_post():
    # 发帖触发自动加粉丝
    auto_follow_list = []
    try:
        # 0-3星
        # 1天前发的帖子：[2-6]个粉丝
        numtime1, numtime2 = time_convs(1, 1)
        user_ids = get_commnet_id(numtime2, numtime1, content_level_low=0, content_level_top=3)
        for user_id in user_ids:
            follow_num = random.randint(3, 6)
            for i in range(follow_num):
                auto_follow_list.append(user_id)

        # 2-15天前发的帖子：[0-1]个粉丝
        numtime1, numtime2 = time_convs(2, 15)
        user_ids = get_commnet_id(numtime2, numtime1, content_level_low=0, content_level_top=3)
        for user_id in user_ids:
            follow_num = random.randint(0, 1)
            for i in range(follow_num):
                auto_follow_list.append(user_id)

        # 15天前或更早发的帖子：每隔11天[0-2]个粉丝
        numtime1, numtime2 = time_convs(2, 15)
        user_ids = get_commnet_id('0', numtime2, content_level_low=0, content_level_top=3)
        for user_id in user_ids:
            follow_num = random.randint(1, 6)
            if follow_num == 6:
                auto_follow_list.append(user_id)

        # 4-6星
        # 1天前发的帖子：[5-10]个粉丝
        numtime1, numtime2 = time_convs(1, 1)
        user_ids = get_commnet_id(numtime2, numtime1, content_level_low=4, content_level_top=6)
        for user_id in user_ids:
            follow_num = random.randint(5, 10)
            for i in range(follow_num):
                auto_follow_list.append(user_id)

        # 2-15天前发的帖子：[0-5]个粉丝
        numtime1, numtime2 = time_convs(2, 15)
        user_ids = get_commnet_id(numtime2, numtime1, content_level_low=4, content_level_top=6)
        for user_id in user_ids:
            follow_num = random.randint(0, 5)
            for i in range(follow_num):
                auto_follow_list.append(user_id)

        # 15天前或更早发的帖子：每隔11天[0-2]个粉丝
        numtime1, numtime2 = time_convs(2, 15)
        user_ids = get_commnet_id('0', numtime2, content_level_low=4, content_level_top=6)
        for user_id in user_ids:
            follow_num = random.randint(1, 6)
            if follow_num == 6:
                auto_follow_list.append(user_id)

    except:
        logging_exception()
        logging.error("catch exception,main:%s" % traceback.format_exc())

    logging.info('auto_follow_per_1d_by_post: len %s' % len(auto_follow_list))
    print('auto_follow_per_1d_by_post: len %s' % len(auto_follow_list))

    total = len(auto_follow_list)
    limit = (total + 10) // 10
    for start in range(0, total, limit):
        batch = auto_follow_list[start:start + limit]
        t = Thread(target=batch_handle, args=[batch])
        t.start()
