#!/usr/bin/env python
# -*- coding: utf-8 -*-

from gm_rpcd.all import bind
import logging
import traceback
import json
from libs.cache import redis_client
from libs.es import ESPerform
from search.utils.group import GroupUtils
from search.utils.common import GroupSortTypes


@bind("physical/search/query_group")
def query_group(query="",offset=0,size=10):
    """
    :remark:小组搜索排序策略，缺少排序策略
    :param query:
    :param offset:
    :param size:
    :return:
    """
    try:
        result_dict = GroupUtils.get_group_query_result(query,offset,size)
        group_ids_list = []

        if len(result_dict["hits"]) > 0:
            group_ids_list = [item["_source"]["id"] for item in result_dict["hits"]]

        return {"group_ids": group_ids_list}
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"group_ids":[]}

@bind("physical/search/group_sort")
def group_sort(user_id=-1,sort_type=GroupSortTypes.HOT_RECOMMEND,offset=0,size=10):
    """
    :remark 小组排序,缺少：前1天发评论人数＊x
    :param user_id:
    :param sort_type:
    :param offset:
    :param size:
    :return:
    """
    try:
        if not isinstance(user_id,int):
            user_id = -1

        if sort_type==GroupSortTypes.HOT_RECOMMEND:
            group_ids_list = GroupUtils.get_hot_group_recommend_result_list(offset,size)

            return {"group_recommend_ids":group_ids_list}

        elif sort_type==GroupSortTypes.ATTENTION_RECOMMEND:
            attention_group_list = GroupUtils.get_user_attention_group_list(user_id,offset=0,size=1)
            if len(attention_group_list)==0:
                return {"group_recommend_ids": []}
            else:
                attention_group_id_list = [item["group_id"] for item in attention_group_list]
                sorted_group_ids_list = GroupUtils.get_group_ids_by_aggs(attention_group_id_list)

                group_recommend_ids_list = sorted_group_ids_list
                if len(group_recommend_ids_list) < size and len(group_recommend_ids_list)<len(attention_group_list):
                    sorted_attention_group_list = sorted(attention_group_list,key=lambda item:item["update_time_val"],reverse=True)
                    for item in sorted_attention_group_list:
                        if item["group_id"] not in group_recommend_ids_list:
                            group_recommend_ids_list.append(item["group_id"])

                return {"group_recommend_ids": group_recommend_ids_list[offset:(offset+size)]}

    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"group_recommend_ids":[]}
