#!/usr/bin/env python
# -*- coding: utf-8 -*-

from gm_rpcd.all import bind
import logging
import traceback
import json
from libs.cache import redis_client
from libs.es import ESPerform
from search.utils.group import GroupUtils
from search.utils.common import GroupSortTypes
from libs.es import ESPerform
from trans2es.models.pictorial import PictorialTopics


@bind("physical/search/product_sort")
def pictorial_topic_sort(query='', offset=0, size=2, sort_type=PRODUCT_ORDER_TYPE.DEFAULT, filters={}):
    '''
    商品sku排序
    :param query:
    :param offset:
    :param size:
    :param sort_type:
    :param filters:
    :return:
    '''
    try:
        res = get_product_sku(query=query, offset=offset, size=size, sort_type=sort_type, filters=filters)

    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"pict_pictorial_ids_list": []}
