#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import sys
import logging
import traceback
from libs.tools import tzlc
import time


class TopicTransfer(object):

    @classmethod
    def get_topic_data(cls,instance):
        try:
            res = dict()

            res["id"] = instance.id
            res["is_online"] = instance.is_online
            res["is_deleted"] = instance.is_deleted
            res["vote_num"] = instance.vote_num
            res["reply_num"] = instance.reply_num
            res["name"] = instance.name
            res["description"] = instance.description
            res["content"] = instance.content
            res["content_level"] = instance.content_level
            res["user_id"] = instance.user_id

            if instance.group:
                res["group_id"] = instance.group.id
            else:
                res["group_id"] = -1
            res["share_num"] = instance.share_num

            res["pick_id_list"] = instance.get_pick_id_info()
            res["tag_list"] = instance.get_topic_tag_id_list()
            res["tag_name_list"] = instance.get_tag_name_list(res["tag_list"])

            res["offline_score"] = instance.get_topic_offline_score()
            #res["manual_score"] = instance.drop_score
            res["manual_score"] = 0

            create_time = instance.create_time
            tzlc_create_time = tzlc(create_time)
            res["create_time"] = tzlc_create_time
            res["create_time_val"] = int(time.mktime(tzlc_create_time.timetuple()))


            update_time = instance.update_time
            tzlc_update_time = tzlc(update_time)
            res["update_time"] = tzlc_update_time
            res["update_time_val"] = int(time.mktime(tzlc_update_time.timetuple()))

            return res
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return None