#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management.base import BaseCommand, CommandError
import traceback
import logging
from libs.es import ESPerform
from django.db import models
import datetime


class User(models.Model):
    class Meta:
        verbose_name = u'用户'
        verbose_name_plural = u'用户'
        db_table = 'user'
        app_label = 'api'

    id = models.IntegerField(verbose_name="用户ID")
    name = models.CharField(verbose_name="用户名称")
    icon = models.CharField(verbose_name='')


    def get_follow_user_id_list(self):
        follow_user_id_list = list()
        user_follows = self.userfollow.filter(is_online=True)
        for user_follow in user_follows:
            follow_user_id_list.append(user_follow.follow_id)

        return follow_user_id_list

    def get_pick_user_id_list(self):
        pick_user_id_list = list()
        user_picks = self.user_pick.filter(is_deleted=False)
        for user_pick in user_picks:
            pick_user_id_list.append(user_pick.pickuser_id)

        return pick_user_id_list



