import json
import logging
import datetime
from libs.cache import redis_client
from libs.error import logging_exception
from django.conf import settings
from trans2es.models.portrait_stat import LikeTopicStat

try:
    ps = redis_client.pubsub()
    ps.subscribe("new_topic_impression")
    all_new_topic_impression_count_key = "all_new_topic_impression_count_key"
    for item in ps.listen():
        if item['type'] == 'message':
            new_topic_ids = json.loads(item["data"])
            all_new_topic_impression_count = json.loads(redis_client.get(all_new_topic_impression_count_key))
            insert_topic_ids = []
            for topic in new_topic_ids:
                topic = str(topic)
                if topic in all_new_topic_impression_count:
                    all_new_topic_impression_count[topic] = all_new_topic_impression_count[topic] + 1
                    if all_new_topic_impression_count[topic] > 100:
                        insert_topic_ids.append(int(topic))
                        all_new_topic_impression_count.pop(topic)
                else:
                    all_new_topic_impression_count[topic] = 1
            if insert_topic_ids:
                insert_list = []
                for topic in insert_topic_ids:
                    insert_list.append(
                        LikeTopicStat(create_time=datetime.datetime.today(), update_time=datetime.datetime.today(),
                                          topic_id=topic, is_new_topic=0, topic_ctr_30=0.0, like_rate_30=0.0))
                LikeTopicStat.objects.using(settings.MASTER_DB_NAME).bulk_create(insert_list)
                logging.info("impressions count gt 100 topic ids" + str(insert_topic_ids))
            json_all_new_topic_impression_count = json.dumps(all_new_topic_impression_count)
            logging.info("all_new_topic_impression_count" + str(all_new_topic_impression_count))
            redis_client.set(all_new_topic_impression_count_key, json_all_new_topic_impression_count)
except:
    logging_exception()
    logging.error("redis new topic sub error!")

