import pymysql
import random
import traceback
import logging
from vest.request.auto_request import login, time_convs, follow
from vest.request.auto_request import host, user, db, passwd
from libs.error import logging_exception


def get_commnet_id(numtime, numtime2):
    pc = pymysql.connect(host=host, user=user, passwd=passwd, db=db, port=3306)
    cursor = pc.cursor()

    # 发贴后
    cursor.execute(

        "select t.user_id from topic t left join user_extra u on t.user_id = u.user_id where u.is_shadow=0 and t.create_time > '%s' and t.create_time < '%s' " % (numtime, numtime2))

    res = cursor.fetchall()
    return res and [i for i, in res] or []


def auto_follow(time_start, time_end, num_low, num_top, num_one=None):
    try:
        user_ids = get_commnet_id(time_start, time_end)
        for user_id in user_ids:
            follow_num = random.randint(num_low, num_top)
            if num_one:
                if follow_num == 1:
                    cookies = login()
                    if cookies is not None:
                        follow(cookies, user_id)
            else:
                for i in range(follow_num):
                    cookies = login()
                    if cookies is not None:
                        follow(cookies, user_id)
    except:
        pass



def auto_follow_per_1d_by_post():
    # 发帖触发自动加粉丝
    try:
        # 0-3星
        # 1天前发的帖子：[2-6]个粉丝
        numtime1, numtime2 = time_convs(1, 1)
        user_ids = get_commnet_id(numtime2, numtime1)
        try:
            for user_id in user_ids:
                follow_num = random.randint(2, 6)
                for i in range(follow_num):
                    cookies = login()
                    if cookies is not None:
                        follow(cookies, user_id)
        except:
            pass

        # 2-15天前发的帖子：[0-1]个粉丝
        numtime1, numtime2 = time_convs(2, 15)
        user_ids = get_commnet_id(numtime2,  numtime1)
        try:
            for user_id in user_ids:
                follow_num = random.randint(0, 1)
                for i in range(follow_num):
                    cookies = login()
                    if cookies is not None:
                        follow(cookies, user_id)
        except:
            pass

        # 15天前或更早发的帖子：每隔11天[0-2]个粉丝
        numtime1, numtime2 = time_convs(2, 15)
        user_ids = get_commnet_id('0', numtime2)
        try:
            for user_id in user_ids:
                follow_num = random.randint(1, 6)
                if follow_num == 6:
                    cookies = login()
                    if cookies is not None:
                        follow(cookies, user_id)
        except:
            pass


        # 4-6星
        # 1天前发的帖子：[5-10]个粉丝
        numtime1, numtime2 = time_convs(1, 1)
        user_ids = get_commnet_id(numtime2, numtime1)
        try:
            for user_id in user_ids:
                follow_num = random.randint(5, 10)
                for i in range(follow_num):
                    cookies = login()
                    if cookies is not None:
                        follow(cookies, user_id)
        except:
            pass

        # 2-15天前发的帖子：[0-5]个粉丝
        numtime1, numtime2 = time_convs(2, 15)
        user_ids = get_commnet_id(numtime2,  numtime1)
        try:
            for user_id in user_ids:
                follow_num = random.randint(0, 5)
                for i in range(follow_num):
                    cookies = login()
                    if cookies is not None:
                        follow(cookies, user_id)
        except:
            pass

        # 15天前或更早发的帖子：每隔11天[0-2]个粉丝
        numtime1, numtime2 = time_convs(2, 15)
        user_ids = get_commnet_id('0', numtime2)
        try:
            for user_id in user_ids:
                follow_num = random.randint(1, 6)
                if follow_num == 6:
                    cookies = login()
                    if cookies is not None:
                        follow(cookies, user_id)
        except:
            pass

    except:
        logging_exception()
        logging.error("catch exception,main:%s" % traceback.format_exc())
