#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import sys
import logging
import traceback
import time
from libs.tools import tzlc
from trans2es.models.user import User
from django.conf import settings


class UserTransfer(object):

    @classmethod
    def get_follow_user_id_list(cls, userInstance):
        follow_user_id_list = list()
        user_follows = userInstance.userfollow.filter(is_online=True)
        for user_follow in user_follows:
            follow_user_id_list.append(user_follow.follow_id)

        follow_user_detail_list = list()
        for i in range(0, len(follow_user_id_list), 1000):
            sql_data_list = User.objects.using(settings.SLAVE_DB_NAME).filter(user_id__in=follow_user_id_list[i:i + 1000], is_online=True,
                                                is_deleted=False)
            for detail_data in sql_data_list:
                item = {
                    "user_id": detail_data.user_id,
                    "country_id": detail_data.country_id
                }
                follow_user_detail_list.append(item)

        return follow_user_detail_list

    @classmethod
    def get_user_data(cls, instance):
        try:
            res = dict()

            res["id"] = instance.id
            res["user_id"] = instance.user_id
            res["nick_name"] = instance.nick_name
            res["profile_pic"] = instance.profile_pic
            res["gender"] = instance.gender
            res["city_id"] = instance.city_id
            res["country_id"] = instance.country_id
            res["is_online"] = instance.is_online
            res["is_deleted"] = instance.is_deleted

            try:
                (is_recommend, is_shadow) = instance.get_is_recommend_flag()
                res["is_recommend"] = is_recommend
                res["is_shadow"] = is_shadow
            except:
                logging.error("catch exception,err_msg:%s" % traceback.format_exc())
                res["is_recommend"] = False
                res["is_shadow"] = False

            try:
                latest_topic_time_val = instance.get_latest_topic_time_val()
                res["latest_topic_time_val"] = latest_topic_time_val
            except:
                logging.error("catch exception,err_msg:%s" % traceback.format_exc())
                res["latest_topic_time_val"] = -1

            tzlc_create_time = tzlc(instance.create_time)
            res["create_time"] = tzlc_create_time
            res["create_time_val"] = int(time.mktime(tzlc_create_time.timetuple()))

            tzlc_update_time = tzlc(instance.update_time)
            res["update_time"] = tzlc_update_time
            res["update_time_val"] = int(time.mktime(tzlc_update_time.timetuple()))

            try:
                res["tag_list"] = instance.get_user_tag_id_list()
                res["useful_tag_list"] = instance.get_user_useful_tag_id_list()
                res["attention_user_id_list"] = cls.get_follow_user_id_list(userInstance=instance)

                # res["attention_group_id_list"] = instance.get_attention_group_id_list()
                res["pick_user_id_list"] = instance.get_pick_user_id_list()

                res["attention_pictorial_id_list"] = instance.get_attention_pictorial_id_list()

                # res["same_group_user_id_list"] = instance.get_same_group_user_id_list()
                res["same_pictorial_user_id_list"] = instance.get_same_pictorial_user_id_list()

            except:
                logging.error("catch exception,err_msg:%s" % traceback.format_exc())
                res["tag_list"] = []
                res["attention_user_id_list"] = []
                # res["attention_group_id_list"] = []
                res["pick_user_id_list"] = []
                # res["same_group_user_id_list"] = []

                res["attention_pictorial_id_list"] = []
                res["same_pictorial_user_id_list"] = []


            return res
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return {}
