import pymysql
import random
import traceback
import logging
from threading import Thread
from vest.request.auto_request import login, time_conv_hour, follow
from vest.request.auto_request import host, user, db, passwd
from libs.error import logging_exception
from libs.timelib import get_rand_time

def get_commnet_id(numtime, numtime2, content_level_low=0, content_level_top=6):
    pc = pymysql.connect(host=host, user=user, passwd=passwd, db=db, port=3306)
    cursor = pc.cursor()

    # 发贴后
    cursor.execute(

        "select t.user_id from topic t left join user_extra u on t.user_id = u.user_id "
        "where IFNULL(u.is_shadow,'')  != 1 and t.create_time > '%s' and t.create_time < '%s' "
        "and t.content_level >= %s and t.content_level <=  %s " % (numtime, numtime2, str(content_level_low), str(content_level_top)))

    res_post = cursor.fetchall()

    # 注册后
    cursor.execute(

        "select  a.user_id from account_user a left join user_extra u on a.user_id = u.user_id "
        "WHERE  a.create_time > '%s' and a.create_time < '%s' and u.is_shadow = 0 " % (numtime, numtime2))

    res_regist = cursor.fetchall()

    res = []
    res.extend(res_regist)
    res.extend(res_post)
    return res and [i for i, in res] or []


def batch_handle(auto_follow_list):
    for user_id in auto_follow_list:
        try:
            cookies = login()
            if cookies is not None:
                # follow(cookies, user_id)
                time = get_rand_time(hourup=0)
                follow.apply_async(args=(cookies, user_id), eta=time)

        except:
            pass


def auto_follow_per_2h_by_post_and_regist():
    # 发帖，注册触发自动加粉丝
    auto_follow_list = []
    try:
        # 发帖，注册后2小时内：[1-3]个粉丝
        numtime1, numtime2 = time_conv_hour(0, 1)
        user_ids = get_commnet_id(numtime2, numtime1, content_level_low=0, content_level_top=6)
        for user_id in user_ids:
            follow_num = random.randint(1, 3)
            for i in range(follow_num):
                auto_follow_list.append(user_id)


    except:
        logging_exception()
        logging.error("catch exception,main:%s" % traceback.format_exc())

    logging.info('auto_follow_per_2h_by_post_and_regist: len %s' % len(auto_follow_list))
    print('auto_follow_per_2h_by_post_and_regist: len %s' % len(auto_follow_list))

    total = len(auto_follow_list)
    limit = (total + 10) // 10
    for start in range(0, total, limit):
        batch = auto_follow_list[start:start + limit]
        t = Thread(target=batch_handle, args=[batch])
        t.start()
