#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import sys
import logging
import traceback
import time
from libs.tools import tzlc

class UserTransfer(object):

    @classmethod
    def get_user_data(cls,instance):
        try:
            res = dict()

            res["id"] = instance.id
            res["user_id"] = instance.user_id
            res["nick_name"] = instance.nick_name
            res["profile_pic"] = instance.profile_pic
            res["gender"] = instance.gender
            res["city_id"] = instance.city_id
            res["country_id"] = instance.country_id
            res["is_online"] = instance.is_online
            res["is_deleted"] = instance.is_deleted

            try:
                (is_recommend, is_shadow) = instance.get_is_recommend_flag()
                res["is_recommend"] = is_recommend
                res["is_shadow"] = is_shadow
            except:
                logging.error("duan test,catch exception,err_msg:%s" % traceback.format_exc())
                res["is_recommend"] = False
                res["is_shadow"] = False

            try:
                latest_topic_time_val = instance.get_latest_topic_time_val()
                res["latest_topic_time_val"] = latest_topic_time_val
                #res["latest_topic_time_val"] = -1
            except:
                logging.error("duan test,catch exception,err_msg:%s" % traceback.format_exc())
                res["latest_topic_time_val"] = -1


            tzlc_create_time = tzlc(instance.create_time)
            res["create_time"] = tzlc_create_time
            res["create_time_val"] = int(time.mktime(tzlc_create_time.timetuple()))

            tzlc_update_time = tzlc(instance.update_time)
            res["update_time"] = tzlc_update_time
            res["update_time_val"] = int(time.mktime(tzlc_update_time.timetuple()))

            try:
                res["tag_list"] = instance.get_user_tag_id_list()
                res["attention_user_id_list"] = instance.get_follow_user_id_list()
                res["attention_group_id_list"] = []
                res["pick_user_id_list"] = []
                res["same_group_user_id_list"] = []
                """
                res["attention_group_id_list"] = instance.get_attention_group_id_list()
                res["pick_user_id_list"] = instance.get_pick_user_id_list()
                res["same_group_user_id_list"] = instance.get_same_group_user_id_list()                
                """
            except:
                logging.error("duan test,catch exception,err_msg:%s" % traceback.format_exc())
                res["tag_list"] = []
                res["attention_user_id_list"] = []
                res["attention_group_id_list"] = []
                res["pick_user_id_list"] = []
                res["same_group_user_id_list"] = []            


            return res
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return None