#!/usr/bin/env python
# -*- coding: utf-8 -*-

from gm_rpcd.all import bind
import logging
import traceback
import json
from search.utils.topic import TopicUtils
from libs.es import ESPerform
from libs.cache import redis_client


@bind("physical/search/home_recommend")
def home_recommend(user_id=-1,offset=0,size=10):
    """
    :remark:首页推荐，目前只推荐日记,缺少小组打散策略
    :return:
    """
    try:
        if not user_id:
            user_id=-1
        redis_key = "physical:home_recommend:" + "user_id:" + str(user_id)
        redis_val_dict = redis_client.hgetall(redis_key)
        if len(redis_val_dict) > 0:
            group_topic_ids = json.loads(redis_val_dict[b"group_topic_ids"])
            not_group_topic_ids = json.loads(redis_val_dict[b"not_group_topic_ids"])
            group_topic_ids_index = int(redis_val_dict[b"group_topic_ids_index"])
            not_group_topic_ids_index = int(redis_val_dict[b"not_group_topic_ids_index"])

            if len(group_topic_ids) < (size-1) or len(not_group_topic_ids) < 1:
                if len(group_topic_ids) < (size-1):
                    group_topic_ids_index += 1
                    (new_group_topic_ids, new_not_group_topic_ids) = TopicUtils.get_recommend_topic_ids(user_id, offset, size,
                                                                                                False, group_topic_ids_index, not_group_topic_ids_index)
                    group_topic_ids += new_group_topic_ids
                else:
                    not_group_topic_ids_index += 1
                    (new_group_topic_ids, new_not_group_topic_ids) = TopicUtils.get_recommend_topic_ids(user_id, offset, size,
                                                                                                False, group_topic_ids_index, not_group_topic_ids_index)
                    not_group_topic_ids += new_not_group_topic_ids

            recommend_topic_ids = group_topic_ids[:(size-1)] + not_group_topic_ids[:1]
            redis_hash_dict = {
                "group_topic_ids": group_topic_ids[(size-1):],
                "not_group_topic_ids": not_group_topic_ids[1:],
                "group_topic_ids_index":group_topic_ids_index,
                "not_group_topic_ids_index":not_group_topic_ids_index
            }
            TopicUtils.refresh_redis_hash_data(redis_client,redis_key,redis_hash_dict)

            return {"recommend_topic_ids":recommend_topic_ids}
        else:
            (group_topic_ids,not_group_topic_ids) = TopicUtils.get_recommend_topic_ids(user_id,offset,size,True,0,0)
            recommend_topic_ids = group_topic_ids[:(size - 1)] + not_group_topic_ids[:1]
            redis_hash_dict = {
                "group_topic_ids": group_topic_ids[(size - 1):],
                "not_group_topic_ids": not_group_topic_ids[1:],
                "group_topic_ids_index": 0,
                "not_group_topic_ids_index": 0
            }
            TopicUtils.refresh_redis_hash_data(redis_client, redis_key, redis_hash_dict)

            return {"recommend_topic_ids": recommend_topic_ids}
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"recommend_topic_ids": []}


@bind("physical/search/home_query")
def home_query(user_id=-1,query="",offset=0,size=10):
    """
    :remark 首页搜索排序,没有做打散,搜索逻辑优化
    :param query:
    :param offset:
    :param size:
    :return:
    """
    try:
        if not user_id:
            user_id=-1
        redis_key = "physical:home_query:" + "user_id:" + str(user_id)
        redis_val_dict = redis_client.hgetall(redis_key)
        if len(redis_val_dict) > 0:
            group_topic_ids = json.loads(redis_val_dict[b"group_topic_ids"])
            not_group_topic_ids = json.loads(redis_val_dict[b"not_group_topic_ids"])
            group_topic_ids_index = int(redis_val_dict[b"group_topic_ids_index"])
            not_group_topic_ids_index = int(redis_val_dict[b"not_group_topic_ids_index"])

            if len(group_topic_ids) < (size-1) or len(not_group_topic_ids) < 1:
                if len(group_topic_ids) < (size-1):
                    group_topic_ids_index += 1
                    (new_group_topic_ids, new_not_group_topic_ids) = TopicUtils.get_recommend_topic_ids(user_id, offset, size,
                                                                                                False, group_topic_ids_index, not_group_topic_ids_index,query)
                    group_topic_ids += new_group_topic_ids
                else:
                    not_group_topic_ids_index += 1
                    (new_group_topic_ids, new_not_group_topic_ids) = TopicUtils.get_recommend_topic_ids(user_id, offset, size,
                                                                                                False, group_topic_ids_index, not_group_topic_ids_index,query)
                    not_group_topic_ids += new_not_group_topic_ids

            recommend_topic_ids = group_topic_ids[:(size-1)] + not_group_topic_ids[:1]
            redis_hash_dict = {
                "group_topic_ids": group_topic_ids[(size-1):],
                "not_group_topic_ids": not_group_topic_ids[1:],
                "group_topic_ids_index":group_topic_ids_index,
                "not_group_topic_ids_index":not_group_topic_ids_index
            }
            TopicUtils.refresh_redis_hash_data(redis_client,redis_key,redis_hash_dict)

            return {"recommend_topic_ids":recommend_topic_ids}
        else:
            (group_topic_ids,not_group_topic_ids) = TopicUtils.get_recommend_topic_ids(user_id,offset,size,True,0,0,query)
            recommend_topic_ids = group_topic_ids[:(size - 1)] + not_group_topic_ids[:1]
            redis_hash_dict = {
                "group_topic_ids": group_topic_ids[(size - 1):],
                "not_group_topic_ids": not_group_topic_ids[1:],
                "group_topic_ids_index": 0,
                "not_group_topic_ids_index": 0
            }
            TopicUtils.refresh_redis_hash_data(redis_client, redis_key, redis_hash_dict)

            return {"recommend_topic_ids": recommend_topic_ids}
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"recommend_topic_ids": []}


@bind("physical/search/topic_detail_page_recommend")
def topic_detail_page_recommend(user_id=-1,topic_id=-1,topic_group_id=-1,topic_user_id=-1,offset=0,size=10):
    """
    :remark:帖子详情页推荐策略，缺少第一个卡片策略
    :param user_id:
    :param topic_id:
    :param topic_group_id:
    :param topic_user_id:
    :return:
    """
    try:
        # 获取帖子标签列表
        topic_tag_list = TopicUtils.get_topic_tag_id_list(topic_id)

        result_list = TopicUtils.get_topic_detail_recommend_list(user_id,topic_tag_list,topic_group_id,topic_user_id,offset,size)
        recommend_topic_ids_list = list()
        if len(result_list)>0:
            recommend_topic_ids_list = [item["_source"]["id"] for item in result_list]

        return {"recommend_topic_ids": recommend_topic_ids_list}
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"recommend_topic_ids": []}


