#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management.base import BaseCommand, CommandError
import traceback
import logging
from libs.es import ESPerform
from django.db import models
import datetime

class Group(models.Model):
    class Meta:
        verbose_name = u'小组'
        app_label = 'community'
        db_table = 'group'

    name = models.CharField(verbose_name=u'名称', max_length=100, default='')
    description = models.CharField(verbose_name=u'描述', max_length=200, default='')
    creator_id = models.IntegerField(verbose_name=u'创建者ID')
    #icon = ImgUrlField('图标', max_length=255, img_type=IMG_TYPE.WATERMARK, default='')
    icon = models.CharField(verbose_name=u'图标', max_length=128, default='')
    topic_num = models.IntegerField(verbose_name=u'帖子数', default=0)
    is_online = models.BooleanField(verbose_name=u"是否有效", default=True, db_index=True)
    is_recommend = models.BooleanField(verbose_name=u"是否推荐", default=False, db_index=True)
    create_time = models.DateTimeField(verbose_name=u'创建时间',default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=datetime.datetime.fromtimestamp(0))

    def detail(self):
        result = {
            'id': self.id,
            'name': self.name,
            'description': self.description,
            'creator_id': self.creator_id,
            'icon': self.icon,
            'topic_num': self.topic_num,
            'create_time': self.create_time.timestamp(),
            'update_time': self.update_time.timestamp(),
        }
        return result