#!/usr/bin/env python
# -*- coding: utf-8 -*-

from gm_rpcd.all import bind
import logging
import traceback
import random
import json
from libs.cache import redis_client
from libs.es import ESPerform
from search.utils.group import GroupUtils
from search.utils.common import GroupSortTypes
from libs.es import ESPerform
from trans2es.models.pictorial import PictorialTopics
from trans2es.models.tag import SettingsConfig, Tag
from libs.cache import redis_client


@bind("physical/search/search_hotword")
def search_hotword(device_id=-1):
    """
    :remark:搜索页的热门灵感
    内容组成：搜索推荐热词register_show_tag
             个性化标签physical:linucb:tag_recommend:device_id:
             核心词，需要去重community_tag  collection 1
    ①先从后台随机取最多6个搜索推荐热词，不够6个则有多少取多少
    ②然后随机取和推荐热词一样数量的linUCB标签，取不够数则取核心标签，linUCB+核心词去重后的数量要和搜索推荐热词的数量一样
    ③最后打乱顺序填入到热门灵感中，超过3行的标签弃掉，不够3行不用管
    :param query:
    :param offset:
    :param size:
    :return:
    """
    try:
        all_tag_name_list = set()
        # results_registr_tag = json.loads(redis_client.get("physical:search_hotword:results_registr_tag"))
        results_tag = json.loads(redis_client.get("physical:search_hotword:results_tag"))
        # 先获取搜索推荐热词
        results_registr_tag = list(set(SettingsConfig.objects.filter(is_deleted=False).values_list("val", flat=True)))
        tag_val_list = set()
        for item in results_registr_tag:
            for word in item.split():
                tag_val_list.add(word)
        tag_id_list = random.sample(range(0, len(tag_val_list)), 6)
        for tag_id in tag_id_list:
            tag_val = list(tag_val_list)[tag_id]
            all_tag_name_list.add(tag_val)
        logging.info("get all_tag_name_list:%s" % all_tag_name_list)

        # 获取个性化标签
        linucb_recommend_redis_prefix = "physical:linucb:tag_recommend:device_id:"
        tag_recommend_redis_key = linucb_recommend_redis_prefix + str(device_id)
        linucb_recommend_tag_data = redis_client.get(tag_recommend_redis_key)
        linucb_recommend_tag_list = json.loads(linucb_recommend_tag_data) if linucb_recommend_tag_data else []
        for item in linucb_recommend_tag_list:
            results_tag_recommend = list(
                set(Tag.objects.filter(id=item, is_online=True).values_list("name", flat=True)))
            if results_tag_recommend:
                all_tag_name_list.add(results_tag_recommend[0])
            logging.info("get all_tag_name_list:%s" % all_tag_name_list)
            if len(all_tag_name_list) == 12:
                return {"recommend_tag_name": list(all_tag_name_list)}

        # 取不够数则取核心标签
        if len(all_tag_name_list) < 12:
            for i in range(0, 12):
                tag_id = random.randint(1, len(results_tag))
                results_tag_hexin = Tag.objects.filter(id=results_tag[tag_id], is_online=True,
                                                       collection=1).values_list("name",
                                                                                 flat=True)
                if results_tag_hexin:
                    if results_tag_hexin[0] not in all_tag_name_list:
                        all_tag_name_list.add(results_tag_hexin[0])
                        logging.info("get all_tag_name_list:%s" % all_tag_name_list)

                        if len(all_tag_name_list) >= 12:
                            return {"recommend_tag_name": list(all_tag_name_list)}

    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"recommend_tag_name": []}

