import traceback
import logging
from trans2es.models.topic import TopicTag, TopicImage, CommunityTopicProduct, Topic, CommunityCategoryTagRelation

from django.conf import settings
from trans2es.models.pictorial import PictorialTag
from random import randint
from trans2es.models.user_extra import UserExtra
from django.db import models


def get_edit_tag_id_list(topic_id):
    try:
        tag_id_list = list(TopicTag.objects.using(settings.SLAVE_DB_NAME).filter(topic_id=topic_id,
                                                                                 is_collection=1).values_list("tag_id",
                                                                                                              flat=True))

        logging.info("get ---tag_id_list:%s" % tag_id_list)
        logging.info("get ---topic_id:%s" % topic_id)
        return tag_id_list
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return []


def get_tag_id_list(topic_id):
    try:
        tag_id_list = list(
            TopicTag.objects.using(settings.SLAVE_DB_NAME).filter(topic_id=topic_id, tag_id=123).values_list("tag_id",
                                                                                                             flat=True))

        return tag_id_list
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return []


def topic_has_image(topic_id):
    try:
        has_image = Topic.objects.using(settings.SLAVE_DB_NAME).filter(id=topic_id, is_deleted=False,
                                                                       is_online=True).values_list("have_face",
                                                                                                   flat=True)
        if has_image[0] == 1:
            return True
        else:
            return False
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return False


def get_topic_product_info(topic_id):
    try:
        has_product = False

        query_list = CommunityTopicProduct.objects.using(settings.SLAVE_DB_NAME).filter(topic_id=topic_id,
                                                                                        is_deleted=False)
        if len(query_list) > 0:
            has_product = True

        return has_product
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return []


def get_pictorial_tag_by_id(pictorial_id):
    try:
        tag_id_list = list(
            PictorialTag.objects.filter(pictorial_id=pictorial_id, is_online=True, is_collection=1).values_list(
                "tag_id", flat=True))

        return tag_id_list
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return []


# def get_topic_data(numtime, numitme2):
#     try:
#
#         result_topic = Topic.objects.filter(create_time__lte=numitme2, create_time__gte=numtime,
#                                             is_online=True).values("user_id", "id")
#
#         if len(result_topic) > 0:
#             for i in result_topic:
#                 shadow_judge = UserExtra.objects.filter(user_id=i[0], is_online=Topic, is_deleted=False).values_list(
#                     "is_shadow", flat=True)
#
#         return shadow_judge
#     except:
#         logging.error("catch exception,err_msg:%s" % traceback.format_exc())
#         return []


def get_category_tag_id(edit_tag_list):
    try:
        logging.info("get -----------")
        # 拿到搜索的分类
        all_category_tag_list = list(
            CommunityCategoryTagRelation.objects.filter(tag_id__in=edit_tag_list, is_online=True,
                                                        is_deleted=False).values_list(
                "category_tag_id", flat=True))

        if len(all_category_tag_list) > 0:
            index = randint(0, len(all_category_tag_list) - 1)

            return all_category_tag_list[index]
        else:
            return 0

    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return -1
