#!/usr/bin/env python
# -*- coding: utf-8 -*-

import time
import logging

class GroupSortTypes(object):
    # 热度排序
    HOT_RECOMMEND=0

    # 关注排序
    ATTENTION_RECOMMEND=1

class PickType(object):
    # 明星榜
    CELEBRITY_PICK=0

    # 帖子榜
    TOPIC_PICK=1

class TopicDocumentField(object):
    """
    帖子索引字段信息
    """
    ID="id",
    IS_ONLINE = "is_online",
    TAG_LIST = "tag_list"



def time_consuming_decorator(func):
    def time_consuming(*args, **kwargs):
        start_time = time.time()
        func(args,kwargs)
        end_time = time.time()

        logging.info("func consuming time:%fs" % (end_time-start_time))

    return time_consuming

