#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging
import traceback
from libs.es import ESPerform


class GroupUtils(object):

    @classmethod
    def get_group_query_result(cls,query,offset,size):
        try:
            q = dict()

            multi_fields = {
                'description': 2,
                'name': 4,
            }
            query_fields = ['^'.join((k, str(v))) for (k, v) in multi_fields.items()]
            multi_match = {
                'query': query,
                'type': 'cross_fields',
                'operator': 'and',
                'fields': query_fields,
            }

            q['query'] = {
                'bool': {
                    "must": {
                        "term":{
                            "is_online": True
                        }
                    },
                    "should": [
                        {'multi_match': multi_match}
                    ],
                    "minimum_should_match": 1
                }
            }
            q["_source"] = {
                "include":["id"]
            }

            return ESPerform.get_search_results(ESPerform.get_cli(), "group", q, offset, size)
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return {"total_count":0, "hits":[]}

    @classmethod
    def get_hot_group_recommend_results(cls,offset,size):
        try:
            q = dict()
            q["query"] = {
                "bool":{
                    "must":{
                        "term":{
                            "is_online": True
                        }
                    }
                }
            }
            q["sort"] = [
                {"high_quality_topic_num":{"order":"desc"}}
            ]
            q["_source"] = {
                "include":["id"]
            }

            return ESPerform.get_search_results(ESPerform.get_cli(),"group",q,offset,size)
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return {"total_count":0, "hits":[]}

    @classmethod
    def get_user_attention_group_list(cls,user_id,offset,size):
        """
        :remark: 获取用户关注小组列表
        :return:
        """
        try:
            q = dict()
            q["query"] = {
                "bool":{
                    "should":[
                        {"term":{
                            "is_online": True
                        }},
                        {"term":{
                            "user_id":user_id
                        }}
                    ],
                    "minimum_should_match":2
                }
            }
            q["_source"] = {
                "include":["attention_group_id_list"]
            }

            result_dict = ESPerform.get_search_results(ESPerform.get_cli(),"user",q,offset,size)
            if len(result_dict["hits"])>0:
                return result_dict["hits"][0]["_source"]["attention_group_id_list"]
            else:
                return []
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return []

    @classmethod
    def get_group_ids_by_aggs(cls,group_id_list):
        """
        :remark:聚合查询获取小组列表
        :param group_id_list:
        :return:
        """
        try:
            q = dict()
            q["size"]=0
            q["query"] = {
                "terms":{
                    "group_id":group_id_list
                }
            }
            q["aggs"] = {
                "group_ids":{
                    "terms":{
                        "field":"group_id"
                    },
                    "aggs":{
                        "max_date":{
                            "max":{
                                "field":"update_time_val"
                            }
                        }
                    }
                }
            }

            result_dict = ESPerform.get_search_results(ESPerform.get_cli(),"topic",q,aggregations_query=True)
            buckets_list = result_dict["aggregations"]["buckets"]

            sorted_buckets_list = sorted(buckets_list,key=lambda item:item["max_date"]["value"],reverse=True)
            sorted_group_id_list = [item["key"] for item in sorted_buckets_list]

            return sorted_group_id_list
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return []