from django.db import models
import datetime
import logging
import traceback
# from .topic import Topic,TopicComplaint,TopicImage

class PictorialTopic(models.Model):
    """画报帖子关系"""

    class Meta:
        verbose_name = u'画报帖子关系'
        app_label = 'community'
        db_table = 'community_pictorial_topic'

    id = models.IntegerField(verbose_name=u'日记ID', primary_key=True)
    pictorial_id = models.BigIntegerField(verbose_name=u'画报ID')
    topic_id = models.BigIntegerField(verbose_name=u'帖子ID')
    is_online = models.BooleanField(verbose_name=u"是否有效", default=True)
    is_online = models.BooleanField(verbose_name=u'是否上线')
    is_deleted = models.BooleanField(verbose_name=u'是否删除')


class PictorialFollow(models.Model):
    """画报关注"""

    class Meta:
        verbose_name = u"画报用户关系"
        app_label = "community"
        db_table = "community_pictorial_follow"

    id = models.IntegerField(verbose_name=u'关注ID', primary_key=True)
    create_time = models.DateTimeField(verbose_name=u'创建时间', default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=datetime.datetime.fromtimestamp(0))
    is_online = models.BooleanField(verbose_name=u'是否上线')
    is_deleted = models.BooleanField(verbose_name=u'是否删除')
    pictorial_id = models.BigIntegerField(verbose_name=u'画报ID')
    user_id = models.BigIntegerField(verbose_name=u'用户ID')


class Pictorial(models.Model):
    """画报关注"""

    class Meta:
        verbose_name = u"画报"
        app_label = "community"
        db_table = "community_pictorial"

    id = models.IntegerField(verbose_name=u'关注ID', primary_key=True)
    create_time = models.DateTimeField(verbose_name=u'创建时间', default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=datetime.datetime.fromtimestamp(0))
    is_online = models.BooleanField(verbose_name=u'是否上线')
    is_deleted = models.BooleanField(verbose_name=u'是否删除')
    is_recommend = models.BooleanField(verbose_name=u'推荐')
    name = models.CharField(verbose_name=u'画报名称', max_length=100)
    description = models.CharField(verbose_name=u'画报描述', max_length=200)
    creator_id = models.BigIntegerField(verbose_name=u'画报用户ID')
    icon = models.CharField(verbose_name=u'画报名称', max_length=255)
    topic_num = models.IntegerField(verbose_name=u'次数')

    # 获取前一天4，5星发帖数
    def get_high_quality_topic_num(self):
        try:
            yesterday = datetime.datetime.now() - datetime.timedelta(days=1)
            yesterday_begin_time = "%s-%s-%s 00:00:00" % (yesterday.year, yesterday.month, yesterday.day)
            yesterday_end_time = "%s-%s-%s 23:59:59" % (yesterday.year, yesterday.month, yesterday.day)


            topic_id_list = PictorialTopic.objects.filter(pictorial_id=self.id).values_list("topic_id",flat=True)

            logging.info("get topic_id_list:%s"%topic_id_list)


            return 10


        #     topic_num = Topic.filter(content_level__in=("4", "5"), create_time__gte=yesterday_begin_time,
        #                              create_time__lte=yesterday_end_time, topic_id_in=topic_id_list).count()
        #
        #     logging.info("get topic_num:%s"%topic_num)
        #
        #
        #     return topic_num
        #
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return False
