import pytz
import random
from datetime import datetime, timedelta

NOW = datetime.now()


def tzlc(dt, truncate_to_sec=True):
    if dt is None:
        return None
    if truncate_to_sec:
        dt = dt.replace(microsecond=0)
    return pytz.timezone('Asia/Shanghai').localize(dt)


def eta_2_push_time(eta):
    if eta:
        eta = datetime.strptime(eta, '%Y-%m-%d %H:%M:%S')
        eta = tzlc(eta)
        return int((eta - datetime.fromtimestamp(0, pytz.timezone("UTC"))).total_seconds())
    else:
        push_time = None
    return push_time


def get_rand_time(hourlow=0, hourup=15, minutelow=0, minuteup=55):
    hours = random.randint(hourlow, hourup)
    minutes = random.randint(minutelow, minuteup)
    # todo redis会自动给加8个小时，所以这边先写死减少8小时
    now_time = NOW + timedelta(hours=hours, minutes=minutes)
    time = eta_2_push_time(now_time.strftime("%Y-%m-%d %H:%M:%S"))
    print(datetime.fromtimestamp(time, pytz.timezone('Asia/Shanghai')))
    return datetime.fromtimestamp(time, pytz.timezone('Asia/Shanghai'))


if __name__ == '__main__':
    get_rand_time()
