import pymysql
import traceback
import logging
import random
from threading import Thread
from vest.request.auto_request import login, time_convs, get_answer_data, reply_answer, get_majia, \
    set_reply_to_redis, judge_topic_info_get_comment, reply, reply2
from vest.request.auto_request import host, user, db, passwd
from libs.error import logging_exception
from libs.timelib import get_rand_time


def get_data(numtime, numtime2, content_level_low, content_level_top):
    try:
        pc = pymysql.connect(host=host, user=user, passwd=passwd, db=db, port=3306)
        cursor = pc.cursor()
        cursor.execute(
            "SELECT id FROM topic WHERE is_online=1  and (create_time >= '%s' and create_time <= '%s' )"
            "and content_level>= %s and content_level<= %s" % (
                numtime2, numtime, str(content_level_low), str(content_level_top)))
        res = cursor.fetchall()
        return res and [r for r, in res] or []

    except:
        logging.error("catch exception,get_data:%s" % traceback.format_exc())
        return []


def batch_handle(topic_id_list):
    for topic_id in topic_id_list:
        try:
            cookies = login()
            if cookies is not None:
                comment = judge_topic_info_get_comment(topic_id)
                if comment:
                    # reply(cookies, topic_id, comment)
                    reply.async_apply(args=(cookies, topic_id, comment), eta=get_rand_time())
                else:
                    comment1, comment2 = get_answer_data()
                    response = reply_answer(cookies, topic_id, comment1)
                    cookies = login()
                    reply_id = response["data"]["id"]
                    reply2.async_apply(args=(cookies, topic_id, comment2, reply_id), eta=get_rand_time())



        except:
            logging_exception()
            logging.error("catch exception,main:%s" % traceback.format_exc())


def auto_reply_per_1d_to_topic():
    topic_id_list = []
    try:
        # 1-3星及无星：
        # 1天前发的帖子：[1-3]个评论
        numtime1, numtime2 = time_convs(1, 1)
        topic_ids = get_data(numtime1, numtime2, 0, 3)
        for topic_id in topic_ids:
            random_num = random.randint(1, 3)
            for num in range(random_num):
                topic_id_list.append(topic_id)

        # 2-6天前发的帖子：[0-1]个评论
        numtime1, numtime2 = time_convs(2, 6)
        topic_ids = get_data(numtime1, numtime2, 0, 3)
        for topic_id in topic_ids:
            random_num = random.randint(0, 1)
            for num in range(random_num):
                topic_id_list.append(topic_id)

        # 4-6星：
        # 1天前发的帖子：[1-6]个评论
        numtime1, numtime2 = time_convs(1, 1)
        topic_ids = get_data(numtime1, numtime2, 4, 6)
        for topic_id in topic_ids:
            random_num = random.randint(1, 6)
            for num in range(random_num):
                topic_id_list.append(topic_id)

        # 2-6天前发的帖子：[1-3]个评论
        numtime1, numtime2 = time_convs(2, 6)
        topic_ids = get_data(numtime1, numtime2, 4, 6)
        for topic_id in topic_ids:
            random_num = random.randint(1, 3)
            for num in range(random_num):
                topic_id_list.append(topic_id)

    except:
        logging_exception()
        logging.error("catch exception,main:%s" % traceback.format_exc())

    logging.info('auto_click_per_2h_by_post: len %s' % len(topic_id_list))
    print('auto_click_per_2h_by_post: len %s' % len(topic_id_list))

    total = len(topic_id_list)
    limit = (total + 10) // 10
    for start in range(0, total, limit):
        batch = topic_id_list[start:start + limit]
        t = Thread(target=batch_handle, args=[batch])
        t.start()