#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management.base import BaseCommand, CommandError
import traceback
import logging
from libs.es import ESPerform
from django.db import models
import datetime

class UserExtra(models.Model):
    class Meta:
        verbose_name=u"推荐用户表"
        db_table="user_extra"

    id = models.IntegerField(verbose_name="主键ID",primary_key=True)
    user_id = models.CharField(verbose_name=u"用户ID",max_length=100)

    is_shadow = models.BooleanField(verbose_name=u"是否是马甲账户")
    is_online = models.BooleanField(verbose_name=u"是否上线")
    is_recommend = models.BooleanField(verbose_name=u"是否推荐")
    has_answered = models.BooleanField(verbose_name=u"")
    is_deleted = models.BooleanField(verbose_name=u"")
    create_time = models.DateTimeField(verbose_name=u'创建时间',default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=datetime.datetime.fromtimestamp(0))