import pymysql
import random
import traceback
import logging
from threading import Thread
from vest.request.auto_request import login, pictorial_reply, get_majia, get_pictorial_comment, time_convs, \
    judge_pictorial_info_get_comment

from vest.request.auto_request import host, user, db, passwd
from vest.data.topic_models import get_pictorial_tag_by_id

"""
榜单新增内容(仅限在线的）
每半小时一次

过去半小时之内，if

新增在线帖子（既包含马甲用户、又包含普通用户）达到1个时，插入{1,2}条评论

新增在线帖子（既包含马甲用户、又包含普通用户）达到2-5个时，插入{2,3}条评论

新增在线帖子（既包含马甲用户、又包含普通用户）达到>5张时，插入{3,5}条评论

（注意评论作者需要是马甲用户）

过去半小时之内，if

本榜单有新增投票（既包含马甲用户、又包含普通用户），插入{1,2}条评论

评论取自单独的榜单评论列表，并自动随机关联马甲

注意需要禁止本帖作者评论
"""


def get_data(numtime1, numtime2):
    try:
        pc = pymysql.connect(host=host, user=user, passwd=passwd, db=db, port=3306)
        cursor = pc.cursor()
        cursor.execute(
            "SELECT id FROM community_pictorial WHERE is_online=1 and (create_time >= '%s' and create_time < '%s') " % (
                numtime2, numtime1))
        res = cursor.fetchall()

        return res and [r for r, in res] or []

    except:
        logging.error("catch exception,get_data:%s" % traceback.format_exc())
        return []


def batch_handle(pictorial_id_list):
    for pictorial_id in pictorial_id_list:
        try:
            cookies = login()
            if cookies is not None:
                comment = judge_pictorial_info_get_comment(pictorial_id)
                pictorial_reply(cookies, pictorial_id, comment)
        except:
            pass


def auto_reply_per_1d_to_pictorial():
    # 问题自动增加回答
    pictorial_id_list = []
    try:
        logging.info("comment offline  pictorial")
        numtime1, numtime2 = time_convs(1, 1)
        pictorial_ids = get_data(numtime1, numtime2)
        for pictorial_id in pictorial_ids:
            random_num = random.randint(0, 1)
            for i in range(random_num):
                pictorial_id_list.append(pictorial_id)

        numtime1, numtime2 = time_convs(2, 6)
        pictorial_ids = get_data(numtime1, numtime2)
        for pictorial_id in pictorial_ids:
            random_num = random.randint(0, 1)
            for i in range(random_num):
                pictorial_id_list.append(pictorial_id)

            else:
                logging.error("catch exception,main:%s" % traceback.format_exc())
    except:
        logging.error("catch exception,main:%s" % traceback.format_exc())

    logging.info('auto_click_per_2h_by_post: len %s' % len(pictorial_id_list))
    print('auto_click_per_2h_by_post: len %s' % len(pictorial_id_list))

    total = len(pictorial_id_list)
    limit = (total + 10) // 10
    for start in range(0, total, limit):
        batch = pictorial_id_list[start:start + limit]
        t = Thread(target=batch_handle, args=[batch])
        t.start()