#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management.base import BaseCommand, CommandError
import traceback
import logging
from libs.es import ESPerform
from django.db import models
import datetime
import time
from libs.tools import tzlc

from .group_user_role import GroupUserRole
from .tag import AccountUserTag
from .topic import Topic
from .user_extra import UserExtra
from .pictorial import PictorialFollow

class User(models.Model):
    class Meta:
        verbose_name = u'用户'
        db_table = 'account_user'

    id = models.IntegerField(verbose_name="主键ID", primary_key=True)
    user_id = models.BigIntegerField(verbose_name=u'用户id', unique=True)
    nick_name = models.CharField(verbose_name=u'昵称', max_length=255, default='')
    profile_pic = models.CharField(verbose_name=u'头像', max_length=300)
    gender = models.SmallIntegerField(verbose_name=u'性别')
    city_id = models.CharField(verbose_name=u'城市id', max_length=60)
    country_id = models.CharField(verbose_name=u'国家id', max_length=40)
    is_online = models.BooleanField(verbose_name="是否上线")
    is_deleted = models.BooleanField(verbose_name='是否删除')
    create_time = models.DateTimeField(verbose_name=u'创建时间', default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=datetime.datetime.fromtimestamp(0))

    def get_is_recommend_flag(self):
        is_shadow = False
        is_recommend = False
        query_sql = UserExtra.objects.using(settings.SLAVE_DB_NAME).filter(user_id=self.user_id, is_deleted=False, is_online=True)
        for record in query_sql:
            is_recommend = record.is_recommend
            is_shadow = record.is_shadow

        return (is_recommend, is_shadow)

    def get_latest_topic_time_val(self):
        latest_topic_time_val = -1

        # 获取该用户最新发帖时间
        topic_records = Topic.objects.using(settings.SLAVE_DB_NAME).filter(user_id=self.user_id).order_by("-update_time").values_list("update_time",
                                                                                                        flat=True).first()
        if topic_records:
            tzlc_topic_update_time = tzlc(topic_records)
            latest_topic_time_val = int(time.mktime(tzlc_topic_update_time.timetuple()))

        return latest_topic_time_val

    def get_follow_user_id_list(self):
        follow_user_id_list = list()
        user_follows = self.userfollow.filter(is_online=True)
        for user_follow in user_follows:
            follow_user_id_list.append(user_follow.follow_id)
        follow_user_detail_list = list()
        logging.info("get follow_user_id_list :%s" % follow_user_id_list)
        for i in range(0, len(follow_user_id_list), 1000):
            logging.info("get follow_user_id_list :%s" % follow_user_id_list[i:i + 1000])
            sql_data_list = User.objects.using(settings.SLAVE_DB_NAME).filter(user_id__in=follow_user_id_list[i:i + 1000])
            for detail_data in sql_data_list:
                item = {
                    "user_id": detail_data.user_id,
                    "country_id": detail_data.country_id
                }
                follow_user_detail_list.append(item)

        return follow_user_detail_list

    def get_attention_group_id_list(self):
        try:
            attention_group_id_list = list()
            query_results = GroupUserRole.objects.using(settings.SLAVE_DB_NAME).filter(is_online=True, user_id=self.user_id)
            for item in query_results:
                item_dict = {
                    "group_id": item.group_id,
                    "update_time_val": time.mktime(tzlc(item.update_time).timetuple())
                }
                attention_group_id_list.append(item_dict)

            return attention_group_id_list
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return []

    def get_attention_pictorial_id_list(self):
        try:
            attention_pictorial_id_list = list()
            query_results = PictorialFollow.objects.using(settings.SLAVE_DB_NAME).filter(is_online=True, user_id=self.user_id)
            for item in query_results:
                item_dict = {
                    "pictorial_id": item.pictorial_id,
                    "update_time_val": time.mktime(tzlc(item.update_time).timetuple())
                }
                attention_pictorial_id_list.append(item_dict)

            return attention_pictorial_id_list
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return []


    def get_pick_user_id_list(self):
        pick_topic_id_list = list()
        user_picks = self.user_pick.using(settings.SLAVE_DB_NAME).filter(is_deleted=False, is_pick=True)
        for user_pick in user_picks:
            pick_topic_id_list.append(user_pick.picktopic_id)

        pick_user_id_list = []
        for i in range(0, len(pick_topic_id_list), 1000):
            topic_sql_list = Topic.objects.using(settings.SLAVE_DB_NAME).filter(id__in=pick_topic_id_list[i:i + 1000])
            for topic_data in topic_sql_list:
                pick_user_id_list.append(topic_data.user_id)

        pick_user_id_list = tuple(pick_user_id_list)
        pick_user_detail_list = list()

        for i in range(0, len(pick_user_id_list), 1000):
            sql_data_list = User.objects.using(settings.SLAVE_DB_NAME).filter(user_id__in=pick_user_id_list[i:i + 1000])
            for detail_data in sql_data_list:
                item = {
                    "user_id": detail_data.user_id,
                    "country_id": detail_data.country_id
                }
                pick_user_detail_list.append(item)

        return pick_user_detail_list

    def get_same_pictorial_user_id_list(self):

        #todo 有的同组数据过大，导致celery cpu过高，暂时限制同组的数据大小，后续可能会去掉同组的数据
        same_pictorial_user_id_list = list()
        pictorial_items_list = list(PictorialFollow.objects.using(settings.SLAVE_DB_NAME).filter(user_id=self.user_id).values_list("pictorial_id",flat=True))
        for pictorial_id in pictorial_items_list:
            user_items_list = list(PictorialFollow.objects.using(settings.SLAVE_DB_NAME).filter(pictorial_id=pictorial_id).values_list("user_id",flat=True))
            for user_id in user_items_list:
                same_pictorial_user_id_list.append(user_id)
                if len(same_pictorial_user_id_list)>=100:
                    break
            if len(same_pictorial_user_id_list)>=100:
                break


        same_pictorial_detail_list = list()
        for i in range(0, len(same_pictorial_user_id_list), 200):
            sql_data_list = User.objects.using(settings.SLAVE_DB_NAME).filter(user_id__in=same_pictorial_user_id_list[i:i + 1000])
            for detail_data in sql_data_list:
                item = {
                    "user_id": detail_data.user_id,
                    "country_id": detail_data.country_id
                }
                same_pictorial_detail_list.append(item)

        return same_pictorial_detail_list

    def get_user_tag_id_list(self):
        try:
            user_tag_id_list = list()

            query_results = AccountUserTag.objects.using(settings.SLAVE_DB_NAME).filter(user=self.user_id, is_deleted=False)
            for item in query_results:
                user_tag_id_list.append(item.tag_id)

            return user_tag_id_list
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return []
