#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, absolute_import, print_function
from gm_rpcd.all import bind
import logging
import traceback
import json
from search.utils.topic import TopicUtils
from libs.es import ESPerform
from libs.cache import redis_client
from search.utils.common import *

@bind("physical/search/home_recommend")
def home_recommend(session_id="",user_id=-1,offset=0,size=10):
    """
    :remark:首页推荐，目前只推荐日记
    :param session_id:
    :param user_id:
    :param offset:
    :param size:
    :return:
    """
    try:
        if not user_id:
            user_id=-1
        if not isinstance(session_id,str):
            session_id = ""
        redis_key = "physical:home_recommend" + ":user_id:" + str(user_id) + ":session_id:" + session_id

        redis_field_list = [b'last_offset_num', b'unread_topic_id', b'have_read_topic_id']
        for page_id in range(0,offset,size):
            redis_field_list.append(str(page_id))
        redis_field_val_list = redis_client.hmget(redis_key,redis_field_list)
        logging.info("duan add,redis_field_list:%s,redis_field_val_list:%s" % (str(redis_field_list),str(redis_field_val_list)))

        redis_val_dict = redis_client.hgetall(redis_key)
        last_offset_num = int(redis_val_dict[b"last_offset_num"]) if b"last_offset_num" in redis_val_dict else -1

        recommend_topic_ids = []

        topic_id_list = TopicUtils.get_recommend_topic_ids(user_id, offset, size*size)
        have_read_group_id_tuple = set()
        unread_topic_id_list = list()
        have_read_topic_id_set = set()

        # 未登录用户已读帖子
        unregister_user_have_redis_topic_id_dict = dict()

        if len(redis_val_dict)>0 and offset>0:
            if user_id>0 and offset==last_offset_num:
                topic_id_list = json.loads(redis_val_dict[b"unread_topic_id"]) + topic_id_list
                have_read_topic_id_set = set(json.loads(redis_val_dict[b"have_read_topic_id"]))
            elif user_id==-1:
                unregister_user_have_redis_topic_id_dict = json.loads(redis_val_dict[b"have_read_topic_id"])
                for page_id in unregister_user_have_redis_topic_id_dict:
                    if int(page_id)<offset:
                        have_read_topic_id_set.union(set(unregister_user_have_redis_topic_id_dict[page_id]))

        for item in topic_id_list:
            if item["group_id"] in have_read_group_id_tuple:
                unread_topic_id_list.append(item)
            else:
                if item["id"] not in have_read_topic_id_set:
                    recommend_topic_ids.append(item["id"])
                    if isinstance(item["group_id"],int) and item["group_id"]>0:
                        have_read_group_id_tuple.add(item["group_id"])

                        have_read_topic_id_set.add(item["id"])
                    if len(recommend_topic_ids) >= size:
                        break
        if len(recommend_topic_ids) < size and len(unread_topic_id_list)>0:
            recommend_len = len(recommend_topic_ids)
            offi_unread_topic_id = [item["id"] for item in unread_topic_id_list[:(size-recommend_len)]]
            recommend_topic_ids = recommend_topic_ids + offi_unread_topic_id
            unread_topic_id_list = unread_topic_id_list[(size-recommend_len):]


        redis_have_redis_data = ""
        if user_id>0:
            redis_have_redis_data = json.dumps(list(have_read_topic_id_set))
        else:
            unregister_user_have_redis_topic_id_dict[offset] = recommend_topic_ids
            redis_have_redis_data = json.dumps(unregister_user_have_redis_topic_id_dict)

        redis_dict = {
            "unread_topic_id":json.dumps(unread_topic_id_list),
            "have_read_topic_id":redis_have_redis_data,
            "last_offset_num":offset+size,
            offset:recommend_topic_ids
        }
        redis_client.hmset(redis_key,redis_dict)
        # 每个session key保存15分钟
        redis_client.expire(redis_key,15*60*60)

        return {"recommend_topic_ids":recommend_topic_ids}
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"recommend_topic_ids": []}


@bind("physical/search/home_query")
def home_query(session_id="",user_id=-1,query="",offset=0,size=10):
    """
    :remark:首页搜索，目前只推荐日记
    :param session_id:
    :param user_id:
    :param query:
    :param offset:
    :param size:
    :return:
    """
    try:
        """
        if not user_id:
            user_id=-1
        if not isinstance(session_id,str):
            session_id = ""
        redis_key = "physical:home_query" + ":user_id:" + str(user_id) + ":session_id:" + session_id + ":query:" + str(query)
        redis_val_dict = redis_client.hgetall(redis_key)
        last_offset_num = int(redis_val_dict[b"last_offset_num"]) if b"last_offset_num" in redis_val_dict else -1

        recommend_topic_ids = []

        topic_id_list = TopicUtils.get_recommend_topic_ids(user_id, offset, size*size,query)
        have_read_group_id_tuple = set()
        unread_topic_id_list = list()
        have_read_topic_id_tuple = set()

        if len(redis_val_dict)>0 and offset>0 and user_id>0 and offset==last_offset_num:
            topic_id_list = json.loads(redis_val_dict[b"unread_topic_id"]) + topic_id_list
            have_read_topic_id_tuple = set(json.loads(redis_val_dict[b"have_read_topic_id"]))
        for item in topic_id_list:
            if item["group_id"] in have_read_group_id_tuple:
                unread_topic_id_list.append(item)
            else:
                if item["id"] not in have_read_topic_id_tuple:
                    recommend_topic_ids.append(item["id"])
                    if isinstance(item["group_id"],int) and item["group_id"]>0:
                        have_read_group_id_tuple.add(item["group_id"])

                    have_read_topic_id_tuple.add(item["id"])
                    if len(recommend_topic_ids) >= size:
                        break
        if len(recommend_topic_ids) < size and len(unread_topic_id_list)>0:
            recommend_len = len(recommend_topic_ids)
            offi_unread_topic_id = [item["id"] for item in unread_topic_id_list[:(size-recommend_len)]]
            recommend_topic_ids = recommend_topic_ids + offi_unread_topic_id
            unread_topic_id_list = unread_topic_id_list[(size-recommend_len):]

        redis_dict = {
            "unread_topic_id":json.dumps(unread_topic_id_list),
            "have_read_topic_id":json.dumps(list(have_read_topic_id_tuple)),
            "last_offset_num":offset+size
        }
        redis_client.hmset(redis_key,redis_dict)
        # 每个session key保存15分钟
        redis_client.expire(redis_key,15*60*60)        
        """
        if not user_id:
            user_id=-1
        if not isinstance(session_id,str):
            session_id = ""
        redis_key = "physical:home_query" + ":user_id:" + str(user_id) + ":session_id:" + session_id + ":query:" + str(query)
        redis_val_dict = redis_client.hgetall(redis_key)
        last_offset_num = int(redis_val_dict[b"last_offset_num"]) if b"last_offset_num" in redis_val_dict else -1

        recommend_topic_ids = []

        topic_id_list = TopicUtils.get_recommend_topic_ids(user_id, offset, size*size,query)
        have_read_group_id_tuple = set()
        unread_topic_id_list = list()
        have_read_topic_id_set = set()

        # 未登录用户已读帖子
        unregister_user_have_redis_topic_id_dict = dict()

        if len(redis_val_dict)>0 and offset>0:
            if user_id>0 and offset==last_offset_num:
                topic_id_list = json.loads(redis_val_dict[b"unread_topic_id"]) + topic_id_list
                have_read_topic_id_set = set(json.loads(redis_val_dict[b"have_read_topic_id"]))
            elif user_id==-1:
                unregister_user_have_redis_topic_id_dict = json.loads(redis_val_dict[b"have_read_topic_id"])
                for page_id in unregister_user_have_redis_topic_id_dict:
                    if int(page_id)<offset:
                        have_read_topic_id_set.union(set(unregister_user_have_redis_topic_id_dict[page_id]))

        for item in topic_id_list:
            if item["group_id"] in have_read_group_id_tuple:
                unread_topic_id_list.append(item)
            else:
                if item["id"] not in have_read_topic_id_set:
                    recommend_topic_ids.append(item["id"])
                    if isinstance(item["group_id"],int) and item["group_id"]>0:
                        have_read_group_id_tuple.add(item["group_id"])

                        have_read_topic_id_set.add(item["id"])
                    if len(recommend_topic_ids) >= size:
                        break
        if len(recommend_topic_ids) < size and len(unread_topic_id_list)>0:
            recommend_len = len(recommend_topic_ids)
            offi_unread_topic_id = [item["id"] for item in unread_topic_id_list[:(size-recommend_len)]]
            recommend_topic_ids = recommend_topic_ids + offi_unread_topic_id
            unread_topic_id_list = unread_topic_id_list[(size-recommend_len):]


        redis_have_redis_data = ""
        if user_id>0:
            redis_have_redis_data = json.dumps(list(have_read_topic_id_set))
        else:
            unregister_user_have_redis_topic_id_dict[offset] = recommend_topic_ids
            redis_have_redis_data = json.dumps(unregister_user_have_redis_topic_id_dict)

        redis_dict = {
            "unread_topic_id":json.dumps(unread_topic_id_list),
            "have_read_topic_id":redis_have_redis_data,
            "last_offset_num":offset+size
        }
        redis_client.hmset(redis_key,redis_dict)
        # 每个session key保存15分钟
        redis_client.expire(redis_key,15*60*60)
        return {"recommend_topic_ids":recommend_topic_ids}
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"recommend_topic_ids": []}


@bind("physical/search/topic_detail_page_recommend")
def topic_detail_page_recommend(user_id=-1,topic_id=-1,topic_group_id=-1,topic_user_id=-1,offset=0,size=10):
    """
    :remark:帖子详情页推荐策略，缺少第一个卡片策略
    :param user_id:
    :param topic_id:
    :param topic_group_id:
    :param topic_user_id:
    :return:
    """
    try:
        if not isinstance(user_id,int):
            user_id = -1

        # 获取帖子标签列表
        topic_tag_list = TopicUtils.get_topic_tag_id_list(topic_id)

        result_list = TopicUtils.get_topic_detail_recommend_list(user_id,topic_id,topic_tag_list,topic_group_id,topic_user_id,offset,size)
        recommend_topic_ids_list = list()
        if len(result_list)>0:
            recommend_topic_ids_list = [item["_source"]["id"] for item in result_list]

        return {"recommend_topic_ids": recommend_topic_ids_list}
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"recommend_topic_ids": []}


