#!/usr/bin/env python
# -*- coding: utf-8 -*-

from gm_rpcd.all import bind
import logging
import traceback
import json
from search.utils.topic import TopicUtils
from libs.es import ESPerform
from libs.cache import redis_client
from search.utils.user import UserUtils


@bind("physical/search/recommend_user")
def recommend_user(recommend_user_id=-1,user_id=-1,offset=0,size=10):
    """
    :remark: 点关注推荐用户,缺少按时间排序策略
    :param user_id:
    :param offset:
    :param size:
    :return:
    """
    try:
        #获取关注用户列表
        attention_user_id_list = UserUtils.get_attention_user_list([user_id])
        #关注的用户 关注用户列表
        recursion_attention_user_id_list = UserUtils.get_attention_user_list(attention_user_id_list)

        recommend_user_list = UserUtils.get_recommend_user_list(attention_user_id_list,recursion_attention_user_id_list,offset,size)

        return recommend_user_list
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"recommend_user_ids":[]}