#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management.base import BaseCommand, CommandError
import traceback
import logging
from libs.es import ESPerform
from django.db import models

class Topic(models.Model):
    class Meta:
        verbose_name = u'日记'
        verbose_name_plural = u'日记'
        db_table = 'topic'
        app_label = 'api'

    group_id = models.IntegerField(verbose_name='日记ID')
    create_time = models.DateTimeField(verbose_name='日记创建时间')
    update_time = models.DateTimeField(verbose_name='日记更新时间')
    name = models.CharField(verbose_name='日记名称')
    user_id = models.IntegerField(verbose_name='用户ID')
    description = models.CharField(verbose_name='日记本描述')
    content = models.CharField(verbose_name='日记本内容')
    share_num = models.IntegerField(verbose_name='')
    vote_num = models.IntegerField(verbose_name='点赞数')
    reply_num = models.IntegerField(verbose_name='回复数')
    cover = models.CharField(verbose_name='')
    is_online = models.BooleanField(verbose_name='是否上线')
    is_deleted = models.BooleanField(verbose_name='是否删除')
    content_level = models.CharField(verbose_name='内容等级')


