#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging
import traceback
from libs.es import ESPerform


class GroupUtils(object):

    @classmethod
    def get_group_query_result(cls,query,offset,size):
        try:
            q = dict()
            q["filter"] = {
                "bool":{
                    "must":{
                        "is_online":True
                    }
                }
            }

            multi_fields = {
                'description': 2,
                'name': 4,
            }
            query_fields = ['^'.join((k, str(v))) for (k, v) in multi_fields.items()]
            multi_match = {
                'query': query,
                'type': 'cross_fields',
                'operator': 'and',
                'fields': query_fields,
            }

            q['query'] = {
                'bool': {
                    "should": [
                        {'multi_match': multi_match}
                    ],
                    "minimum_should_match": 1
                }
            }
            q["_source"] = {
                "include":["id"]
            }

            return ESPerform.get_search_results(ESPerform.get_cli(), "group", q, offset, size)
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return {"total_count":0, "hits":[]}

    @classmethod
    def get_hot_group_recommend_results(cls,offset,size):
        try:
            q = dict()
            q["filter"] = {
                "bool":{
                    "must":{
                        "is_online":True
                    }
                }
            }
            q["sort"] = [
                {"high_quality_topic_num":{"order":"desc"}}
            ]
            q["_source"] = {
                "include":["id"]
            }

            return ESPerform.get_search_results(ESPerform.get_cli(),"group",q,offset,size)
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return {"total_count":0, "hits":[]}

    @classmethod
    def get_user_attention_group_list(cls,user_id,offset,size):
        """
        :remark: 获取用户关注小组列表
        :return:
        """
        try:
            q = dict()
            q["filter"] = {
                "bool":{
                    "must":{
                        "is_online":True,
                        "user_id":user_id
                    }
                }
            }
            q["_source"] = {
                "include":["attention_group_id_list"]
            }

            result_dict = ESPerform.get_search_results(ESPerform.get_cli(),"user",q,offset,size)
            if len(result_dict["hits"])>0:
                return result_dict["hits"][0]["attention_group_id_list"]
            else:
                return []
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return []
