
import json

from django.http import HttpResponse


def json_response(result, status=200, extra_headers=None):

    if extra_headers is None:
        extra_headers = {}

    if 'extra' not in result:
        result['extra'] = {}

    if 'data' not in result:
        result['data'] = {}

    response = HttpResponse(
        json.dumps(result),
        content_type="application/json; charset=UTF-8",
        status=status,
    )
    for header_key, header_value in extra_headers.items():
        response[header_key] = header_value

    return response


def get_error_message(code, extra=None):

    result = {'error': 0}

    if code >= 10000:
        result['error'] = 1

    result['error_code'] = code

    msg = ERROR_CODE.getDesc(code)
    if extra:
        msg += ' %s' % extra
    result['message'] = msg

    return result