import json

from api.views.base_view import BaseView

from libs.user import get_user_by_ids
from alpha_types.neptune import ERROR
from alpha_types.neptune import PRODUCT_FLATFORM
from engine.logger import info_logger, error_logger


class ProductBatchCreate(BaseView):
    '''批量创建商品 爬虫入口'''
    def post(self, request):
        product_info = json.loads(request.POST.get('data', '[]'))

        if not product_info:
            return self.error(self.get_ErrorInfo(ERROR.PARAMS_INCOMPLETE))

        result = []

        for info in product_info:
            error, ret = self.process(info)
            if error:
                return self.error(error)
            result.append(ret)

        return self.ok(data=result)

    def process(self, info):
        if not info:
            return None, None
        brand_info = info.pop('brand', {})
        composition_infos = info.pop('composition', [])
        category_info = info.pop('category', {})
        effect_info = info.pop('effect', {})

        product_id = None
        if info:
            error, result = self.create_product(info)
            if error:
                return error, None
            product_id = result.get('id')
            if not product_id:
                return error, None # 创建商品失败 未获取到商品ID
        
        self.add_parallel_rpc_call_info('create_brand', 'neptune/commodity/brand/create',
                                        cn_name=brand_info.get('cnName'), icon=brand_info.get('imgSrc'),
                                        description=brand_info.get('description'), en_name=brand_info.get('en_name'),
                                        origin_brand_id=brand_info.get('id'), platform=PRODUCT_FLATFORM.BEVOL, product_id=product_id)
        
        self.add_parallel_rpc_call_info('batch_create_composition', 'neptune/commodity/composition/batch_create',
                                        infos=composition_infos, platform=PRODUCT_FLATFORM.BEVOL, product_id=product_id)

        self.add_parallel_rpc_call_info('create_category', 'neptune/commodity/category/create',
                                        cn_name=category_info.get('name'), platform=PRODUCT_FLATFORM.BEVOL, 
                                        origin_category_id=category_info.get('id'), product_id=product_id)
        
        self.add_parallel_rpc_call_info('create_effect', 'neptune/commodity/effect/create',
                                        cn_name=effect_info.get('name'), origin_effect_id=effect_info.get('id'),
                                        platform=PRODUCT_FLATFORM.BEVOL, product_id=product_id)

        self.shoot_rpc_calls_in_parallel()
        
        error, _ = self.parallel_rpc_call_result['create_brand']
        if error:
            return error, None
    
        error, _ = self.parallel_rpc_call_result['batch_create_composition']
        if error:
            return error, None
    
        error, _ = self.parallel_rpc_call_result['create_category']
        if error:
            return error, None

        error, _ = self.parallel_rpc_call_result['create_effect']
        if error:
            return error, None

        return None, result

    def create_product(self, product_info):
        error, ret = self.call_rpc('neptune/commodity/product/create', 
                                   cn_name=product_info.get('cn_name'), norms=product_info.get('norms'),
                                   grades=product_info.get('grades'), price=product_info.get('price'),
                                   en_name=product_info.get('en_name'), country=product_info.get('country'),
                                   origin_product_id=product_info.get('id'), platform=PRODUCT_FLATFORM.BEVOL)
        return error, ret


class BrandBatchCreate(BaseView):
    '''批量创建品牌'''
    def post(self, request):
        brand_infos = request.POST.get('data')
        if not brand_infos:
            return self.error(self.get_ErrorInfo(ERROR.PARAMS_INCOMPLETE))
        error, ret = self.call_rpc('neptune/commodity/brand/batch_create', 
                                   infos=brand_infos, platform=PRODUCT_FLATFORM.BEVOL)
        return error, ret

