
import json

from api.views.base_view import BaseView, get_offset_count


class UpdateGraspStatus(BaseView):
    """
    更新用户爬取状态
    """
    def post(self, request):
        user_id = int(request.POST.get("user_id", 0))
        relation_account_id = request.POST.get("relation_account_id", "")
        error, _data = self.call_rpc(
            "venus/community/user/update_grasp_status",
            user_id=user_id,
            relation_account_id=relation_account_id
        )
        if error:
            return self.error(error)

        return self.ok(data=_data)


class ShadowUserList(BaseView):
    '''
    列表获取马甲用户
    '''
    def get(self, request):
        offset, count = get_offset_count(request)
        error, _data = self.call_rpc(
            "venus/community/user/shadow/list", offset=offset, count=count
        )
        if error:
            return self.error(error)
        users = _data.get('users')
        result = {
            'users': [{'user_id': item.get('user_id')} for item in users if item],
            'total': _data.get('total')
            }

        return self.ok(data=result)


class Validate3PartyAccount(BaseView):
    """
    验证三方账号是否已绑定过
    """
    def post(self, request):
        _ids = request.POST.get("account_ids") or '[]'
        account_ids = json.loads(_ids)

        err, _data = self.call_rpc(
            "venus/community/validate_has_bind_3party_account",
            bind_account_ids=account_ids
        )

        if err:
            return self.error(err)
        data = {account_id: _data.get(account_id, False) for account_id in account_ids}
        return self.ok(data=data)
