from xlrd import open_workbook
from urllib.request import urlopen, Request
from urllib import parse
import json
import math

import requests


PAGE_SIZE = 100


def read_excel():
    wb = open_workbook(filename='/Users/haowei/Desktop/nice_tag20181225.xlsx')

    sheet1 = wb.sheet_by_index(0)

    tags = []
    for i in range(1, sheet1.nrows):
        item = sheet1.row_values(i)
        if item:
            if item[1]:
                tags.append({'name': item[1], 'img': item[-1]})

    print(len(tags))
    return tags


def create_tags(tags):
    url='http://39.107.208.122:80/api/v1/create_tag_for_batch'

    post_data = json.dumps(tags)
    textmod= {"tags": post_data}
    print(textmod)
    req = requests.post(url=url, data=textmod)
    print(req.text)


def process():
    tags = read_excel()

    # create_tags([{"name": "aaa", "img": "http://www.baidu.com"}, {"name": "bbb", "img": "http://www.baidu.com"}])

    count = math.ceil(len(tags) / PAGE_SIZE)
    print(count)
    for i in range(0, count):
        print(i)
        item = tags[PAGE_SIZE * i: PAGE_SIZE * i + PAGE_SIZE]
        # print(item, len(item))
        create_tags(item)

if __name__ == "__main__":
    process()
