
from django.conf.urls import url

from .views import user
from .views import topic
from .views import tag
from .views import reply
from .views import product
from .views import pictorial


urlpatterns = [
    # grasp
    url(r'^v1/update_grasp_status$', user.UpdateGraspStatus.as_view(), name='update_grasp_status$'),

    # topic
    url(r'^v1/create_topic_for_batch$', topic.CreateTopicForBatch.as_view(), name='create_topic_for_batch'),
    url(r'^v1/create_topic_for_batch_by_one$', topic.CreateTopicForBatchByOne.as_view(), name='create_topic_for_batch_by_one'),

    # tag
    url(r'^v1/create_tag_for_batch$', tag.CreateTagForBatch.as_view(), name='create_tag_for_batch'),

    # user
    url(r'^v1/user/shadow/list$', user.ShadowUserList.as_view(), name='create_tag_for_batch'),
    url(r'^v1/validate_3party_or_account$', user.Validate3PartyOrAccount.as_view(), name='validate_3party_or_account'),
    url(r'^v1/validate_3party_account$', user.Validate3PartyAccount.as_view(), name='validate_3party_account$'),
    url(r'^v1/user/batch_create_shadow_user$', user.BatchCreateShadowUser.as_view(), name='batch_create_shadow_user$'),
    url(r'^v1/user/batch_update_user_level_fans$', user.BatchUpdateUserLevelFansNum.as_view(), name='batch_update_user_level_fans$'),

    # reply
    url(r'^v1/reply/create_for_inner$', reply.CreateReplyForInner.as_view(), name='create_reply_for_inner'),

    # product
    url(r'^v1/product/batch_create$', product.ProductBatchCreate.as_view(), name='product_batch_create'),
    url(r'^v1/brand/batch_create$', product.BrandBatchCreate.as_view(), name='brand_batch_create'),

    # pictorial
    url(r'^v1/pictorial/create$', pictorial.CreatePictorial.as_view(), name='pictorial_create'),
]
