import json

from api.views.base_view import BaseView
from api.utils.sensitive import Sensitive


class CreateTagForBatch(BaseView):
    """
    内部使用，批量建标签
    """
    def post(self, request):
        tag_list = json.loads(request.POST.get("tags", '[]'))
        need_check = request.POST.get('need_check', 0)

        tags = []
        if need_check:
            # 敏感词检测，获取可用的帖子
            check_info = Sensitive.check([item["name"] for item in tag_list if item.get("name")])
            for tag in tag_list:
                succ = check_info.get(tag.get("name")) if tag.get("name") else True
                if not succ:
                    tags.append({"name": tag})
        else:
            tags = tag_list
        error, data = self.call_rpc('venus/community/tag/batch_create_not_classify', data=tags)

        if error:
            return self.error(error)

        return self.ok(data=data)
