import json


from api.views.base_view import BaseView
from api.utils.sensitive import Sensitive


class CreateTopicForBatch(BaseView):
    """
    内部使用，批量建帖
    """
    def post(self, request):

        user_id = request.POST.get("user_id", 0)
        topic_list = json.loads(request.POST.get("topic_list", '[]'))

        if not user_id:
            return self.parameter_invalid_response()

        if not topic_list:
            return self.ok()

        topics = []
        # 敏感词检测，获取可用的帖子
        check_info = Sensitive.check([topic["content"] for topic in topic_list if topic.get("content")])
        for topic in topic_list:
            succ = check_info.get(topic.get("content")) if topic.get("content") else True
            if not succ:
                topics.append(topic)

        if not topics:
            return self.ok()

        tag_names = []
        for item in topics:
            tag_names.extend(item.get("tags", []))
            item["user_id"] = user_id

        check_info = Sensitive.check(tag_names)
        tags  = [tag_name for tag_name, succ in check_info.items() if not succ]

        # 先创建标签
        _tag_error, _tag_data = self.call_rpc(
            "venus/community/tag/batch_create_tag_by_name",
            tag_names=tags
        )
        if _tag_error:
            return self.error(_tag_error)

        # 更新发帖
        for item in topics:
            item["tag_ids"] = [
                _tag_data[tag_name]
                for tag_name in item.get("tags", []) if _tag_data.get(tag_name)
            ]

        print(topics)
        create_err, result = self.call_rpc(
            "venus/community/topic/batch_create_for_inner",
            topic_list=topics
        )
        if create_err:
            return self.error(create_err)

        return self.ok(data=result)
