"""敏感词等反垃圾相关。"""


from engine.rpc import get_current_rpc_invoker
from libs.spawn_task import SpawnTask, Task


class DRIVERS(object):
    """后续可能接入多个服务"""

    YIDUN = "1"  # "易盾"


class ENDPOINT(object):
    """请求入口。"""

    # 所有请求接入到 antispam 服务中
    endpoint = {
        DRIVERS.YIDUN: "antispam/yidun",
    }

    def __getitem__(self, key):
        try:
            return self.endpoint[key]
        except KeyError:
            raise Exception("没有对应的检测平台")


class Sensitive(object):
    """敏感词等反垃圾相关入口。"""

    endpoint = ENDPOINT()

    @classmethod
    def _check_job(cls, endpoint, text):
        """内容检测"""

        rpc = get_current_rpc_invoker()
        try:
            res = rpc[endpoint](text=text).unwrap()
        except:
            res = None

        return res

    @classmethod
    def check(cls, text_list, driver=DRIVERS.YIDUN):
        """检测"""

        endpoint = cls.endpoint[driver]

        tasks = [Task(cls._check_job, endpoint, text) for text in text_list]
        spawn = SpawnTask(tasks)

        spawn.run()

        data = []
        if driver == DRIVERS.YIDUN:
            for res in spawn.result:
                data.append(cls._yidun_paraser(res))

        return data

    @classmethod
    def _yidun_paraser(cls, data):
        """易盾结果解析"""
        # {
        #   'code': 200,
        #   'msg': 'ok',
        #   'result': {
        #       'taskId': 'd28e036d95874361916a26d406ea7db9',
        #       'action': 2,
        #       'labels': [
        #           {
        #               'label': 600,
        #               'level': 2,
        #               'details': {
        #                   'hint': ['傻逼']
        #               }
        #           }
        #       ]
        #   }
        # }
        hints = []
        if not data or "detail" in data:  # 程序出错啦
            return

        action = data["result"]["action"]
        if action == 0:  # "通过"
            return []

        lables = data.get("result", {}).get("labels", [])
        for lable in lables:
            hints.extend(lable.get('details', {}).get("hint"))

        return hints
