import json

from api.views.base_view import BaseView
from api.utils.sensitive import Sensitive
from api.cache.cache import ins_cache

from libs.user import get_user_by_ids
from alpha_types.venus import ERROR as CODES


ins_account_cache = "ins_account_cache"


class CreateTopicForBatch(BaseView):
    """
    内部使用，批量建帖
    """

    def post(self, request):

        user_id = request.POST.get("user_id", 0)
        card_level = request.POST.get("card_level", 0)
        tag_id = request.POST.get("tag_id")
        is_online = request.POST.get("is_online", 0)
        topic_list = json.loads(request.POST.get("topic_list", '[]'))

        if not user_id:
            return self.parameter_invalid_response()

        user_info = get_user_by_ids([user_id])
        if not user_info:
            return self.error(self.get_ErrorInfo(CODES.USER_NOT_FOUND))

        if not topic_list:
            return self.ok()

        topics = []
        # 敏感词检测，获取可用的帖子
        # check_info = Sensitive.check([topic["content"] for topic in topic_list if topic.get("content")])
        # for topic in topic_list:
        #     if topic.get('content'):
        #         succ = check_info.get(topic.get("content"))
        #         if not succ:
        #             topics.append(topic)
        #     else:
        #         if topic.get('images') or topic.get('video'):
        #             topics.append(topic)
        for topic in topic_list:
            if topic.get('content'):
                topics.append(topic)
            else:
                if topic.get('images') or topic.get('video'):
                    topics.append(topic)

        if not topics:
            return self.ok()

        tag_names = []
        for item in topics:
            tags = item.get("tags") or []
            tag_names.extend([tag.replace("#", '').strip() for tag in tags])
            item["user_id"] = user_id
            item["card_level"] = card_level
            item["tag_id"] = tag_id if tag_id else None
            item["is_online"] = is_online

        not_exists_ids = []
        topic_list = []
        for item in topics:

            _id = item.get("id")
            exists = ins_cache.sismember(ins_account_cache, _id)
            if exists:
                continue

            topic_list.append(item)
            not_exists_ids.append(_id)

        # check_info = Sensitive.check(tag_names)
        # tags  = [tag_name for tag_name, succ in check_info.items() if not succ]
        tags  = tag_names

        # 先创建标签
        _tag_error, _tag_data = self.call_rpc(
            "venus/community/tag/batch_create_tag_by_name",
            tag_names=tags
        )
        if _tag_error:
            return self.error(_tag_error)

        # 更新发帖
        # 处理标签，将文本中的标签处理成现有标签
        for item in topic_list:
            tags = item.get("tags") or []
            tags = [tag.replace("#", '').strip() for tag in tags]
            content = item["content"]
            for tag_name, tag_id  in _tag_data.items():
                if tag_name in tags:
                    alpha_tag = '<topic>{' + '"id":{},"name":"{}"'.format(tag_id, tag_name) + '}</topic>'
                    content = content.replace('#' + tag_name, alpha_tag)
            item["content"] = content.replace('#', '')

            item["tag_ids"] = [
                _tag_data[tag_name]
                for tag_name in tags if _tag_data.get(tag_name)
            ]

        create_err, result = self.call_rpc(
            "venus/community/topic/batch_create_for_inner",
            topic_list=topic_list
        )
        if create_err:
            return self.error(create_err)

        # 将已经跑了的数据添加到缓存
        if not_exists_ids:
            ins_cache.sadd(ins_account_cache, *not_exists_ids)

        return self.ok(data=result)


class CreateTopicForBatchByOne(BaseView):
    """
    内部使用，一对一批量建帖
    """
    def post(self, request):

        user_ids = json.loads(request.POST.get("user_ids", '[]'))
        topic_list = json.loads(request.POST.get("topic_list", '[]'))

        if not user_ids:
            return self.parameter_invalid_response()

        if not topic_list:
            return self.ok()

        topics = []
        # 敏感词检测，获取可用的帖子
        # check_info = Sensitive.check([topic["content"] for topic in topic_list if topic.get("content")])
        # for topic in topic_list:
        #     if topic.get('content'):
        #         succ = check_info.get(topic.get("content"))
        #         if not succ:
        #             topics.append(topic)
        #     else:
        #         if topic.get('images') or topic.get('video'):
        #             topics.append(topic)

        for topic in topic_list:
            if topic.get('content'):
                topics.append(topic)
            else:
                if topic.get('images') or topic.get('video'):
                    topics.append(topic)

        if not topics:
            return self.ok()

        tag_names = []
        need_create_topics = []
        for item, user_id in zip(topics, user_ids):
            tags = item.get("tags") or []
            tag_names.extend([tag.replace("#", '').strip() for tag in tags])
            item["user_id"] = user_id
            need_create_topics.append(item)

        # check_info = Sensitive.check(tag_names)
        # tags  = [tag_name for tag_name, succ in check_info.items() if not succ]
        # check_info = Sensitive.check(tag_names)
        tags  = tag_names

        # 先创建标签
        _tag_error, _tag_data = self.call_rpc(
            "venus/community/tag/batch_create_tag_by_name",
            tag_names=tags
        )
        if _tag_error:
            return self.error(_tag_error)

        # 更新发帖
        # 处理标签，将文本中的标签处理成现有标签
        for item in need_create_topics:
            tags = item.get("tags") or []
            tags = [tag.replace("#", '').strip() for tag in tags]
            content = item["content"]
            for tag_name, tag_id  in _tag_data.items():
                if tag_name in tags:
                    alpha_tag = '<topic>{' + '"id":{},"name":"{}"'.format(tag_id, tag_name) + '}</topic>'
                    content = content.replace('#' + tag_name, alpha_tag)
            item["content"] = content.replace('#', '')

            item["tag_ids"] = [
                _tag_data[tag_name]
                for tag_name in tags if _tag_data.get(tag_name)
            ]

        create_err, result = self.call_rpc(
            "venus/community/topic/batch_create_for_inner",
            topic_list=need_create_topics
        )
        if create_err:
            return self.error(create_err)

        return self.ok(data=result)