

class DictWrapperUseDot(object):
    """wrap a dict, get key by dot syntax."""

    def __init__(self, _dict):
        assert isinstance(_dict, dict)
        self.__data = {}

        for k, v in _dict.items():
            if isinstance(v, dict):
                self.__data[k] = DictWrapperUseDot(v)
            else:
                self.__data[k] = v

    def __getattr__(self, attr):
        return self.__data[attr]

