import json


from api.views.base_view import BaseView
from libs.sensitive import Sensitive


class CreateTopicForBatch(BaseView):
    """
    内部使用，批量建帖
    """
    def post(self, request):

        user_id = request.POST.get("user_id", 0)
        topic_list = json.loads(request.POST.get("topic_list", '[]'))

        if not user_id:
            return self.parameter_invalid_response()

        if not topic_list:
            return self.ok()

        # TODO: 过滤topic.content敏感词

        tag_names = []
        for item in topic_list:
            tag_names.extend(item.get("tags", []))
            item["user_id"] = user_id

        check_info = Sensitive.check(list(filter(None, set(tag_names))))
        tags  = check_info.values()

        # 先创建标签
        _tag_error, _tag_data = self.call_rpc(
            "venus/community/tag/batch_create_tag_by_name",
            tag_names=list(tags)
        )
        if _tag_error:
            return self.error(_tag_error)

        # 更新发帖
        for item in topic_list:
            item["tag_ids"] = [_tag_data.get(tag_name, 0) for tag_name in item.get("tags", [])]

        create_err, result = self.call_rpc(
            "venus/community/topic/batch_create_for_inner",
            topic_list=topic_list
        )
        if create_err:
            return self.error(create_err)

        return self.ok(data=result)
