import json
from datetime import datetime
from utils.base import APIView, get_offset_count


class ActivityListView(APIView):

    def get(self, request):
        offset, count = get_offset_count(request)
        name = request.GET.get('name', None)
        is_online = request.GET.get('is_online', None)
        sort_by = request.GET.get('sort_by', None)

        data = self.rpc['venus/sun/activity/list'](offset=offset, count=count, name=name, is_online=is_online, sort_by=sort_by).unwrap()
        return data


class ActivityInfoView(APIView):
    
    def get(self, request):
        id_ = request.GET.get('id')

        data = self.rpc['venus/sun/activity/get'](id_=id_).unwrap()
        return data


class ActivityCreateView(APIView):

    def post(self, request):
        name = request.POST.get('name', None)
        un_join_url = request.POST.get('un_join_url', None)
        in_join_url = request.POST.get('in_join_url', None)
        agreement_url = request.POST.get('agreement_url', None)

        if not name:
            return r'缺少参数'

        data = self.rpc['venus/sun/activity/add'](name=name, un_join_url=un_join_url, in_join_url=in_join_url, agreement_url=agreement_url).unwrap()

        return data


class ActivityUpdateView(APIView):
    
    def post(self, request):
        id_ = request.POST.get('id', None)
        name = request.POST.get('name', None)
        un_join_url = request.POST.get('un_join_url', None)
        in_join_url = request.POST.get('in_join_url', None)
        agreement_url = request.POST.get('agreement_url', None)
        rank = request.POST.get('rank', None)

        if not id_:
            return r'缺少参数'

        data = self.rpc['venus/sun/activity/edit'](id_=id_, name=name, un_join_url=un_join_url, in_join_url=in_join_url, agreement_url=agreement_url, rank=rank).unwrap()
        if not data:
            return r'更新失败'

        return data


class ActivityDeleteView(APIView):
    
    def post(self, request):
        ids = json.loads(request.POST.get('ids', '[]'))
        if not ids:
            return r'缺少参数'

        for id_ in ids:
            
            data = self.rpc['venus/sun/activity/delete'](id_=id_).unwrap()
            if not data:
                return r'操作失败'

        return data


class PictorialActivityListView(APIView):

    def get(self, request):

        name = request.GET.get('name', '')
        page = int(request.GET.get('page', 1))
        count = int(request.GET.get('count', 10))

        data = self.rpc['venus/sun/activity/pictrial/list'](name=name, offset=(page - 1) * count, count=count).unwrap()
        if not data:
            return r'获取失败'

        return data


class PictorialActivityView(APIView):

    def get(self, request):

        id_ = int(request.GET.get('id'))

        data = self.rpc['venus/sun/activity/pictrial/info'](id_=id_).unwrap()
        if not data:
            return r'获取失败'

        return data.get("data")

    def post(self, request):

        data = {
            "id": request.POST.get('id'),
            "name": request.POST.get('name', ''),
            "start_time": request.POST.get('start_time'),
            "end_time": request.POST.get('end_time'),
            "version": request.POST.get('version', '0.0.0'),
            "banner": request.POST.get('banner', ''),
            "description": request.POST.get('description',''),
            "titles": json.loads(request.POST.get('titles', '[]'))
        }

        data = self.rpc['venus/sun/activity/pictrial/edit'](data=data).unwrap()

        if not data:
            return r'操作失败'

        return data


class PictorialActivityOlineView(APIView):

    def post(self, request):

        id_ = int(request.POST.get('id'))
        is_online = int(request.POST.get('is_online'))

        data = self.rpc['venus/sun/activity/pictrial/online'](id_=id_, is_online=is_online).unwrap()
        if not data:
            return r'操作失败'

        return data

