import json
from utils.base import APIView, get_offset_count
from utils.logger import error_logger


class WordParentListView(APIView):

    def get(self, request):
        offset, count = get_offset_count(request)
        name = request.GET.get('name', None)
        is_online = request.GET.get('is_online', None)

        data = self.rpc['venus/sun/word_parent/list'](offset=offset, count=count, name=name, is_online=is_online).unwrap()
        return data


class WordParentInfoView(APIView):
    
    def get(self, request):
        
        id_ = request.GET.get('id')

        data = self.rpc['venus/sun/word_parent/get'](id_=id_).unwrap()
        return data


class WordParentCreateView(APIView):

    def post(self, request):
        name = request.POST.get('name', None)
        children_words = json.loads(request.POST.get('children_words', '[]'))
        content_ad = request.POST.get('content_ad', '')
        makeup_ad = request.POST.get('makeup_ad', '')
        dress_ad = request.POST.get('dress_ad', '')

        if not name:
            return r'缺少参数'

        data = self.rpc['venus/sun/word_parent/add'](name=name, children_words=children_words, content_ad=content_ad, makeup_ad=makeup_ad, dress_ad=dress_ad).unwrap()

        return data


class WordParentUpdateView(APIView):
    
    def post(self, request):
        id_ = request.POST.get('id', None)
        name = request.POST.get('name', None)
        children_words = json.loads(request.POST.get('children_words', '[]'))
        content_ad = request.POST.get('content_ad', None)
        makeup_ad = request.POST.get('makeup_ad', None)
        dress_ad = request.POST.get('dress_ad', None)
        gender = request.POST.get('gender', None)

        if not id_:
            return r'缺少参数'

        data = self.rpc['venus/sun/word_parent/edit'](id_=id_, name=name, children_words=children_words, content_ad=content_ad, makeup_ad=makeup_ad, dress_ad=dress_ad, gender=gender).unwrap()
        if not data:
            return r'更新失败'

        return data


class WordParentDeleteView(APIView):
    
    def post(self, request):
        ids = json.loads(request.POST.get('ids', '[]'))

        if not ids:
            return r'缺少参数'

        for id_ in ids:
            data = self.rpc['venus/sun/word_parent/delete'](id_=id_).unwrap()
            if not data:
                return r'操作失败'

        return data
