
import Layout from '@/views/layout/Layout'


const TopicRouter = {
  path: '/topic',
  component: Layout,
  redirect: '/topic/list',
  name: 'Topic',
  meta: {
    title: '帖子管理',
    icon: 'component',
    roles: ['staff', 'anonymous']
  },
  children: [
    {
      path: 'list',
      component: () => import('@/views/topic/list'),
      name: 'TopicList',
      meta: {title: '帖子列表', icon: 'list'}
    },
    {
      path: 'create',
      component: () => import('@/views/topic/create'),
      name: 'CreateTopic',
      meta: {title: '创建帖子', icon: 'edit'}
    },
    {
      path: 'edit/:id(\\d+)',
      component: () => import('@/views/topic/edit'),
      name: 'EditTopic',
      meta: {title: '编辑帖子', noCache: true},
      hidden: true
    }
  ]
}

export default TopicRouter
