#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/11/17

import json
from utils.base import APIView
from utils.logger import error_logger


class TagListView(APIView):
    def get(self, request):
        offset = int(request.GET.get('offset', 1))
        limit = int(request.GET.get('limit', 10))
        filter = self.handle_filter(request.GET.get('filter', ""))
        try:
            data = self.rpc['venus/sun/tag/list'](offset=(offset-1) * limit, limit=limit, filters=filter).unwrap()
        except Exception as e:
            error_logger.error(u'获取标签列表失败%s', e)
            raise
        return data

    def post(self, request):
        ids = json.loads(request.POST.get('ids', '[]'))
        updates = json.loads(request.POST.get('updates', '{}'))
        try:
            self.rpc['venus/sun/tag/batch/update'](updates=updates, ids=ids).unwrap()
        except Exception as e:
            error_logger.error(u'批量更新标签列表失败%s', e)
            raise
        return {
            "message": "更新成功"
        }


class TagUpdateOrCreateView(APIView):
    def get(self, request):
        id = request.GET.get('id')
        try:
            data = self.rpc['venus/sun/tag/get'](id=id).unwrap()
        except Exception as e:
            error_logger.error(u'获取标签%d信息失败%s'%(int(id), e))
            raise
        if not data:
            data = {}
        else:
            pass
        return {'data': data}

    def post(self, request):
        id = request.POST.get('id')
        down_tags = list(set(map(lambda x: x.split(":")[0], json.loads((request.POST.get('down_tags', '[]'))))))
        up_tags = list(set(map(lambda x: x.split(":")[0], json.loads((request.POST.get('up_tags', '[]'))))))
        tagtypes = list(set(map(lambda x: x.split(":")[0], json.loads((request.POST.get('tagtypes', '[]'))))))
        data = {
            'name': request.POST.get('name').lower(),
            'description': request.POST.get('description'),
            'down_tags': down_tags,
            'up_tags': up_tags,
            'tagtypes': tagtypes,
            'icon_url': request.POST.get('icon_url', '')[:-2],
            'platform': request.POST.get('platform'),
            'collection': request.POST.get('collection'),
            'alias': request.POST.get('alias')
        }
        try:
            data = self.rpc['venus/sun/tag/edit'](id=id, data=data).unwrap()
        except Exception as e:
            error_logger.error(u'创建/编辑标签%d信息失败%s' % (id, e))
            raise
        return data


class TagTypeListView(APIView):
    def get(self, request):
        offset = int(request.GET.get('offset', 1))
        limit = int(request.GET.get('limit', 10))
        filter = self.handle_filter(request.GET.get('filter', ""))
        try:
            data = self.rpc['venus/sun/tag/tagtype/list'](offset=(offset - 1) * limit, limit=limit, filters=filter).unwrap()
        except Exception as e:
            error_logger.error(u'获取标签类型列表失败%s', e)
            raise
        return data

    def post(self, request):
        ids = json.loads(request.POST.get('ids', '[]'))
        updates = json.loads(request.POST.get('updates', '{}'))

        try:
            self.rpc['venus/sun/tag/tagtype/batch/update'](updates=updates, ids=ids).unwrap()
        except Exception as e:
            error_logger.error(u'批量更新标签类型列表失败%s', e)
            raise
        return {
            "message": "更新成功"
        }


class TagTypeUpdateOrCreateView(APIView):
    def get(self, request):
        id = request.GET.get('id')
        try:
            data = self.rpc['venus/sun/tag/tagtype/get'](id=id).unwrap()
        except Exception as e:
            error_logger.error(u'获取标签%d信息失败%s'%(id, e))
            raise
        if not data:
            data = {}
        else:
            pass
        return {'data': data}

    def post(self, request):
        id = request.POST.get('id')
        data = {
            'name': request.POST.get('name'),
        }
        try:
            data = self.rpc['venus/sun/tag/tagtype/edit'](id=id, data=data).unwrap()
        except Exception as e:
            error_logger.error(u'创建/编辑标签类型%d信息失败%s' % (id, e))
            raise
        return data
