#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/11/15

import json
from utils.base import APIView
from utils.logger import error_logger


class TopicListView(APIView):
    def get(self, request):
        user_id = request.GET.get('user_id', '')
        offset = int(request.GET.get('page', 0))
        limit = int(request.GET.get('limit', 10))
        filters = json.loads(request.GET.get('filter', "{}"))
        sorts_by = '2'  # request.GET.getlist('sort[]')
        if user_id:
            filters.update({'user_id': user_id})

        res = self.rpc['physical/search/business/topic'](
            offset=offset * limit,
            size=limit,
            filters=filters,
            sorts_by=sorts_by
        ).unwrap()

        topic_ids = res.get("topic_ids", [])
        total_count = res.get("total_count", 0)

        try:
            data = self.rpc['venus/sun/topic/list'](
                topic_ids=topic_ids
            ).unwrap()
        except Exception as e:
            error_logger.error(u'获取帖子列表失败%s', e)
            raise

        result = {
            "data": data.get("data", []),
            "total": total_count,
        }

        return result


class TopicImageListView(APIView):
    def get(self, request):
        page = int(request.GET.get('page', 1))
        limit = int(request.GET.get('limit', 50))
        filters = json.loads(request.GET.get('filter', "{}"))
        sorts_by = '2'  # request.GET.getlist('sort[]')

        res = self.rpc['physical/search/business/topic'](
            offset=(page-1) * limit,
            size=limit,
            filters=filters,
            sorts_by=sorts_by
        ).unwrap()

        topic_ids = res.get("topic_ids", [])
        total_count = res.get("total_count", 0)

        try:
            data = self.rpc['venus/community/topic/images_info_dict'](
                topic_ids=topic_ids
            ).unwrap()
        except Exception as e:
            error_logger.error(u'获取帖子列表失败%s', e)
            raise

        result = []
        for topic_id in topic_ids:

            imgs_info = data.get(topic_id, [])
            if not imgs_info:
                continue

            result.append({
                "id": topic_id,
                "img_url": imgs_info[0].get("url", "")
            })

        result = {
            "data": data.get("data", []),
            "total": total_count,
        }

        return result


class TopicUpdateOrCreateView(APIView):
    def get(self, request):
        id = request.GET.get('id')

        try:
            data = self.rpc['venus/sun/topic/get'](id=id).unwrap()
        except Exception as e:
            error_logger.error(u'获取%s-帖子信息失败%s' %(id, e))
            raise
        return {'data': data}

    def post(self, request):
        id = request.POST.get('id', '')
        topic_images = list(map(lambda x: x[:-2], json.loads(request.POST.get('topic_images', []))))
        tag_ids = list(map(lambda x: x.split(':')[0], json.loads(request.POST.get('tags', '[]'))))
        collection_tag_ids = list(map(lambda x: x.split(':')[0], json.loads(request.POST.get('collection_tags', '[]'))))

        data = {
            'topic_images': topic_images,
            'video_url': request.POST.get('video_url', ''),
            'posting_time': request.POST.get('posting_time'),
            'content': request.POST.get('content', ''),
            'content_level': request.POST.get('content_level', ''),
            'group_id': request.POST.get('group', '').split(':')[0],
            'user_id': request.POST.get('user', '').split(':')[0],
            'star_id': request.POST.get('star', '').split(':')[0],
            'tag_ids': tag_ids,
            'collection_tag_ids': collection_tag_ids,
            'is_online': int(request.POST.get('is_online')),
            'drop_score': int(request.POST.get('drop_score')),
            'has_image': 1 if topic_images else 0,
            'has_video': 1 if request.POST.get('video_url', '') else 0,
        }
        try:
            self.rpc['venus/sun/topic/edit'](id=id, data=data).unwrap()
        except Exception as e:
            error_logger.error(u'创建/编辑%s-帖子信息失败%s' % (id, e))
            raise
        return {
            'message': '更新成功'
        }


class ReplyUpdateOrCreateView(APIView):
    def get(self, request):
        id = request.GET.get('id')
        offset = int(request.GET.get('page', 0))
        limit = int(request.GET.get('limit', 10))
        filter = self.handle_filter(request.GET.get('filter', ""))
        filter.update({'topic_id': id})
        try:
            data = self.rpc['venus/sun/topic/reply/list'](offset=(offset-1) * limit, limit=limit, filters=filter).unwrap()
        except Exception as e:
            error_logger.error(u'回复帖子失败%s' , e)
            raise
        return data

    def post(self, request):
        reply_ids = json.loads(request.POST.get('reply_ids', []))
        try:
            self.rpc['venus/sun/topic/reply/batch_delete'](ids=reply_ids).unwrap()
        except Exception as e:
            error_logger.error(u'批量更新帖子失败%s', e)
            raise
        return {
            'message': '操作成功'
        }


class ReplyCreate(APIView):
    def post(self, request):
        request.POST.get('be_replied_id', None)
        data = {
            'user_id': request.POST.get('user_id').split(':')[0],
            'replied_id': request.POST.get("replied_id", None),
            'topic_id': request.POST.get("topic_id", None),
            'content': request.POST.get('content'),
            'replied_user_id': request.POST.get('replied_user_id', None)
        }
        try:
            data = self.rpc['venus/sun/topic/reply/edit'](id=None, data=data).unwrap()
        except Exception as e:
            error_logger.error(u'编辑帖子失败%s', e)
            raise
        return {'data': data}


class TopicListBatchUpdate(APIView):

    def post(self, request):
        ids = request.POST.get('ids', '').split()
        updates = self.handle_filter(request.POST.get('updates', "{}"))
        extra = json.loads(request.POST.get('extra', '{}'))
        try:
            self.rpc['venus/sun/topic/batch/update'](updates=updates, ids=ids, extra=extra).unwrap()
        except Exception as e:
            error_logger.error(u'批量更新帖子失败%s', e)
            raise
        return {
            "message": "更新成功"
        }
